/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.trusteddevice;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.trusteddevice.AccountFailedLogin;
import de.justsoftware.authorization.trusteddevice.AccountFailedLoginRepository;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0012J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0012J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0012J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/authorization/trusteddevice/AccountFailedLoginService;", "", "observationDurationMinutes", "", "accountFailedLoginRepository", "Lde/justsoftware/authorization/trusteddevice/AccountFailedLoginRepository;", "<init>", "(ILde/justsoftware/authorization/trusteddevice/AccountFailedLoginRepository;)V", "getObservationDurationMinutes", "()I", "countFailedLoginAttempt", "Lde/justsoftware/authorization/trusteddevice/AccountFailedLogin;", "profileId", "Lde/justsoftware/authorization/id/ProfileId;", "updateExistingAttemptCount", "existingAttemptCount", "updateAttemptCount", "createNewAttemptCount", "hasPreviousObservationPeriodEnded", "", "observationStart", "Ljava/time/Instant;", "just-authorization-server"})
public class AccountFailedLoginService {
    private final int observationDurationMinutes;
    @NotNull
    private final AccountFailedLoginRepository accountFailedLoginRepository;

    public AccountFailedLoginService(@Value(value="${just.security.failedLogin.observationMinutes:10}") int observationDurationMinutes, @NotNull AccountFailedLoginRepository accountFailedLoginRepository) {
        Intrinsics.checkNotNullParameter((Object)accountFailedLoginRepository, (String)"accountFailedLoginRepository");
        this.observationDurationMinutes = observationDurationMinutes;
        this.accountFailedLoginRepository = accountFailedLoginRepository;
    }

    public int getObservationDurationMinutes() {
        return this.observationDurationMinutes;
    }

    @NotNull
    public AccountFailedLogin countFailedLoginAttempt(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        AccountFailedLogin existingFailedLogin = this.accountFailedLoginRepository.getByProfileId(profileId);
        return existingFailedLogin == null ? this.createNewAttemptCount(profileId) : this.updateExistingAttemptCount(existingFailedLogin);
    }

    private AccountFailedLogin updateExistingAttemptCount(AccountFailedLogin existingAttemptCount) {
        return this.hasPreviousObservationPeriodEnded(existingAttemptCount.getCountedSince()) ? this.createNewAttemptCount(existingAttemptCount.getProfileId()) : this.updateAttemptCount(existingAttemptCount);
    }

    private AccountFailedLogin updateAttemptCount(AccountFailedLogin existingAttemptCount) {
        return this.accountFailedLoginRepository.upsertAndReturn(new AccountFailedLogin(existingAttemptCount.getProfileId(), existingAttemptCount.getFailCount() + 1, existingAttemptCount.getCountedSince()));
    }

    private AccountFailedLogin createNewAttemptCount(ProfileId profileId) {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return this.accountFailedLoginRepository.upsertAndReturn(new AccountFailedLogin(profileId, 1, instant));
    }

    private boolean hasPreviousObservationPeriodEnded(Instant observationStart) {
        return observationStart.until(Instant.now(), ChronoUnit.MINUTES) > (long)this.getObservationDurationMinutes();
    }
}

