/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.stats;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.stats.UserActivity;
import de.justsoftware.authorization.stats.UserStatsRepository;
import de.justsoftware.authorization.stats.UserStatsService;
import java.time.Instant;
import javax.annotation.ParametersAreNonnullByDefault;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\tH\u0011\u00a2\u0006\u0002\b\nJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/authorization/stats/UserStatsService;", "", "userStatsRepository", "Lde/justsoftware/authorization/stats/UserStatsRepository;", "<init>", "(Lde/justsoftware/authorization/stats/UserStatsRepository;)V", "listen", "", "activity", "Lde/justsoftware/authorization/stats/UserActivity;", "listen$just_authorization_server", "updateLastLoginMobile", "profileId", "Lde/justsoftware/authorization/id/ProfileId;", "Companion", "just-authorization-server"})
public class UserStatsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserStatsRepository userStatsRepository;
    @NotNull
    private static final Logger LOG;

    public UserStatsService(@NotNull UserStatsRepository userStatsRepository) {
        Intrinsics.checkNotNullParameter((Object)userStatsRepository, (String)"userStatsRepository");
        this.userStatsRepository = userStatsRepository;
    }

    @KafkaListener(id="just.auth.userStatsConsumer", containerFactory="userStatsKafkaListenerContainerFactory", topics={"just.stats.userStats"})
    public void listen$just_authorization_server(@Payload @NotNull UserActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        LOG.debug("Received user stats activity: {}", (Object)activity);
        switch (WhenMappings.$EnumSwitchMapping$0[activity.getUserActivityType().ordinal()]) {
            case 1: {
                this.userStatsRepository.updateLastLoginDesktop(activity.getProfileId(), activity.getTimestamp());
                break;
            }
            case 2: {
                this.userStatsRepository.updateLastAccessMobile(activity.getProfileId(), activity.getTimestamp());
                break;
            }
            case 3: {
                this.userStatsRepository.updateLastAccessDesktop(activity.getProfileId(), activity.getTimestamp());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void updateLastLoginMobile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.userStatsRepository.updateLastLoginMobile(profileId, instant);
    }

    static {
        Logger logger = LoggerFactory.getLogger(UserStatsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

