/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.kafka.tenant;

import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.kafka.tenant.TenantData;
import de.justsoftware.authorization.settings.SettingsService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/authorization/kafka/tenant/KafkaTenantConsumer;", "", "settingsService", "Lde/justsoftware/authorization/settings/SettingsService;", "<init>", "(Lde/justsoftware/authorization/settings/SettingsService;)V", "listen", "", "key", "", "payload", "Lde/justsoftware/authorization/kafka/tenant/TenantData;", "just-authorization-server"})
public class KafkaTenantConsumer {
    @NotNull
    private final SettingsService settingsService;

    public KafkaTenantConsumer(@NotNull SettingsService settingsService) {
        Intrinsics.checkNotNullParameter((Object)settingsService, (String)"settingsService");
        this.settingsService = settingsService;
    }

    @KafkaListener(containerFactory="tenantListenerContainerFactory", topics={"just.tenants"})
    public void listen(@Header(value="kafka_receivedMessageKey") @NotNull String key, @Payload(required=false) @Nullable TenantData payload) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (payload == null) {
            TenantId tenantId = TenantId.Companion.fromString(key);
            this.settingsService.delete(tenantId);
        } else {
            this.settingsService.insertIfTenantDoesNotExist(payload.getId());
        }
    }
}

