/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcLogoutAuthenticationToken;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/authorization/config/LogoutSuccessHandler;", "Lorg/springframework/security/web/authentication/AuthenticationSuccessHandler;", "rememberMeServices", "Lorg/springframework/security/web/authentication/rememberme/PersistentTokenBasedRememberMeServices;", "defaultRedirectUri", "", "<init>", "(Lorg/springframework/security/web/authentication/rememberme/PersistentTokenBasedRememberMeServices;Ljava/lang/String;)V", "onAuthenticationSuccess", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "authentication", "Lorg/springframework/security/core/Authentication;", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nLogoutSuccessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogoutSuccessHandler.kt\nde/justsoftware/authorization/config/LogoutSuccessHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class LogoutSuccessHandler
implements AuthenticationSuccessHandler {
    @NotNull
    private final PersistentTokenBasedRememberMeServices rememberMeServices;
    @NotNull
    private final String defaultRedirectUri;

    public LogoutSuccessHandler(@NotNull PersistentTokenBasedRememberMeServices rememberMeServices, @NotNull String defaultRedirectUri) {
        Intrinsics.checkNotNullParameter((Object)rememberMeServices, (String)"rememberMeServices");
        Intrinsics.checkNotNullParameter((Object)defaultRedirectUri, (String)"defaultRedirectUri");
        this.rememberMeServices = rememberMeServices;
        this.defaultRedirectUri = defaultRedirectUri;
    }

    /*
     * WARNING - void declaration
     */
    public void onAuthenticationSuccess(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Authentication authentication) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        OidcLogoutAuthenticationToken oidcLogoutAuthentication = (OidcLogoutAuthenticationToken)authentication;
        String redirectUri = this.defaultRedirectUri;
        if (oidcLogoutAuthentication.isAuthenticated() && StringUtils.hasText((String)oidcLogoutAuthentication.getPostLogoutRedirectUri())) {
            Object object;
            UriComponentsBuilder uriComponentsBuilder;
            UriComponentsBuilder uriBuilder;
            String string = oidcLogoutAuthentication.getPostLogoutRedirectUri();
            if (string != null) {
                String it = string;
                boolean bl = false;
                v1 = UriComponentsBuilder.fromUriString((String)it);
            } else {
                v1 = uriBuilder = null;
            }
            if (StringUtils.hasText((String)oidcLogoutAuthentication.getState()) && (uriComponentsBuilder = uriBuilder) != null) {
                String string2;
                Object[] objectArray;
                String string3 = "state";
                Object[] objectArray2 = objectArray = new Object[1];
                int n = 0;
                String string4 = oidcLogoutAuthentication.getState();
                if (string4 != null) {
                    void it;
                    String bl = string4;
                    int n2 = n;
                    Object[] objectArray3 = objectArray2;
                    String string5 = string3;
                    UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder;
                    boolean bl2 = false;
                    String string6 = UriUtils.encode((String)it, (Charset)StandardCharsets.UTF_8);
                    uriComponentsBuilder = uriComponentsBuilder2;
                    string3 = string5;
                    objectArray2 = objectArray3;
                    n = n2;
                    string2 = string6;
                } else {
                    string2 = null;
                }
                objectArray2[n] = string2;
                uriComponentsBuilder.queryParam(string3, objectArray);
            }
            if ((object = uriBuilder) == null || (object = object.build(true)) == null || (object = object.toUriString()) == null) {
                object = this.defaultRedirectUri;
            }
            redirectUri = object;
        }
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            httpSession.invalidate();
        }
        this.rememberMeServices.logout(request, response, authentication);
        String[] stringArray = new String[]{"JSESSIONID"};
        new CookieClearingLogoutHandler(stringArray).logout(request, response, authentication);
        new DefaultRedirectStrategy().sendRedirect(request, response, redirectUri);
    }
}

