/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.InputArgument;
import de.justsoftware.admin.connector.llm.LlmApiConnector;
import de.justsoftware.admin.graphql.generated.types.LlmLoginInput;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/LlmModelsFetcher;", "", "llmApiConnector", "Lde/justsoftware/admin/connector/llm/LlmApiConnector;", "<init>", "(Lde/justsoftware/admin/connector/llm/LlmApiConnector;)V", "llmModels", "Ljava/util/concurrent/CompletableFuture;", "", "", "login", "Lde/justsoftware/admin/graphql/generated/types/LlmLoginInput;", "admin-service"})
public class LlmModelsFetcher {
    @NotNull
    private final LlmApiConnector llmApiConnector;

    public LlmModelsFetcher(@NotNull LlmApiConnector llmApiConnector) {
        Intrinsics.checkNotNullParameter((Object)llmApiConnector, (String)"llmApiConnector");
        this.llmApiConnector = llmApiConnector;
    }

    @DgsData(parentType="Query", field="llmModels")
    @NotNull
    public CompletableFuture<List<String>> llmModels(@InputArgument @NotNull LlmLoginInput login) {
        Intrinsics.checkNotNullParameter((Object)login, (String)"login");
        return this.llmApiConnector.getStreamableModels(login.getUrl(), login.getApiKey());
    }
}

