/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.TenantApplicationService;
import de.justsoftware.admin.application.web.drive.DriveApplicationService;
import de.justsoftware.admin.application.web.drive.DriveSettings;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.graphql.dataFetchers.DriveFetcherKt;
import de.justsoftware.admin.graphql.dataFetchers.ProfileDataLoader;
import de.justsoftware.admin.graphql.dataFetchers.TenantFetcherKt;
import de.justsoftware.admin.graphql.generated.types.DriveAntiVirusIssue;
import de.justsoftware.admin.graphql.generated.types.DriveAntiVirusIssueUpdateInput;
import de.justsoftware.admin.graphql.generated.types.DriveAntiVirusIssues;
import de.justsoftware.admin.graphql.generated.types.DriveSettingsInput;
import de.justsoftware.admin.graphql.generated.types.Profile;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.id.ProfileId;
import graphql.schema.DataFetchingEnvironment;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001a\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0010H\u0017J$\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0010H\u0017J\u001a\u0010\u0016\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0010H\u0017J\u001a\u0010\u0018\u001a\u00020\r2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u0010H\u0017J\u001a\u0010\u001b\u001a\u00020\r2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u0010H\u0017J\u0018\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\u0006\u0010\n\u001a\u00020\u0010H\u0017J\u0018\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\u0006\u0010\n\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/DriveFetcher;", "", "driveApplicationService", "Lde/justsoftware/admin/application/web/drive/DriveApplicationService;", "tenantApplicationService", "Lde/justsoftware/admin/application/web/TenantApplicationService;", "<init>", "(Lde/justsoftware/admin/application/web/drive/DriveApplicationService;Lde/justsoftware/admin/application/web/TenantApplicationService;)V", "driveSettings", "Lde/justsoftware/admin/application/web/drive/DriveSettings;", "dfe", "Lgraphql/schema/DataFetchingEnvironment;", "updateDriveSettings", "Lde/justsoftware/admin/graphql/generated/types/Tenant;", "input", "Lde/justsoftware/admin/graphql/generated/types/DriveSettingsInput;", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "antiVirusIssues", "Lde/justsoftware/admin/graphql/generated/types/DriveAntiVirusIssues;", "offset", "", "limit", "updateAntiVirusIssue", "Lde/justsoftware/admin/graphql/generated/types/DriveAntiVirusIssueUpdateInput;", "rescanAntiVirusIssue", "id", "", "deleteAntiVirusIssue", "antiVirusIssueUploadedBy", "Ljava/util/concurrent/CompletableFuture;", "Lde/justsoftware/admin/graphql/generated/types/Profile;", "antiVirusIssueStatusUpdatedBy", "admin-service"})
@SourceDebugExtension(value={"SMAP\nDriveFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriveFetcher.kt\nde/justsoftware/admin/graphql/dataFetchers/DriveFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public class DriveFetcher {
    @NotNull
    private final DriveApplicationService driveApplicationService;
    @NotNull
    private final TenantApplicationService tenantApplicationService;

    public DriveFetcher(@NotNull DriveApplicationService driveApplicationService, @NotNull TenantApplicationService tenantApplicationService) {
        Intrinsics.checkNotNullParameter((Object)driveApplicationService, (String)"driveApplicationService");
        Intrinsics.checkNotNullParameter((Object)tenantApplicationService, (String)"tenantApplicationService");
        this.driveApplicationService = driveApplicationService;
        this.tenantApplicationService = tenantApplicationService;
    }

    @DgsData(parentType="Tenant", field="driveSettings")
    @NotNull
    public DriveSettings driveSettings(@NotNull DataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.driveApplicationService.getSettings((AuthorizationContext)DgsContext.Companion.getCustomContext(dfe));
    }

    @DgsMutation(field="updateDriveSettings")
    @NotNull
    public Tenant updateDriveSettings(@InputArgument @NotNull DriveSettingsInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.driveApplicationService.updateSettings(input, authContext);
        return TenantFetcherKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }

    @DgsData(parentType="Tenant", field="driveAntiVirusIssues")
    @NotNull
    public DriveAntiVirusIssues antiVirusIssues(@InputArgument int offset, @InputArgument int limit, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return DriveFetcherKt.access$toGql((de.justsoftware.admin.application.web.drive.DriveAntiVirusIssues)this.driveApplicationService.getAntiVirus().getIssues(offset, limit, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="updateDriveAntiVirusIssue")
    @NotNull
    public Tenant updateAntiVirusIssue(@InputArgument @NotNull DriveAntiVirusIssueUpdateInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.driveApplicationService.getAntiVirus().updateIssue(DriveFetcherKt.access$toDomain((DriveAntiVirusIssueUpdateInput)input), authContext);
        return TenantFetcherKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }

    @DgsMutation(field="rescanDriveAntiVirusIssue")
    @NotNull
    public Tenant rescanAntiVirusIssue(@InputArgument @NotNull String id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.driveApplicationService.getAntiVirus().rescanIssue(id, authContext);
        return TenantFetcherKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }

    @DgsMutation(field="deleteDriveAntiVirusIssue")
    @NotNull
    public Tenant deleteAntiVirusIssue(@InputArgument @NotNull String id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.driveApplicationService.getAntiVirus().deleteIssue(id, authContext);
        return TenantFetcherKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }

    @DgsData(parentType="DriveAntiVirusIssue", field="uploadedBy")
    @NotNull
    public CompletableFuture<Profile> antiVirusIssueUploadedBy(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        ProfileId profileId = ((DriveAntiVirusIssue)dfe.getSourceOrThrow()).getUploadedById();
        CompletableFuture completableFuture = dataLoader.load((Object)profileId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="DriveAntiVirusIssue", field="statusUpdatedBy")
    @NotNull
    public CompletableFuture<Profile> antiVirusIssueStatusUpdatedBy(@NotNull DgsDataFetchingEnvironment dfe) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
                DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
                ProfileId profileId = ((DriveAntiVirusIssue)dfe.getSourceOrThrow()).getStatusUpdatedById();
                object = profileId;
                if (object == null) break block2;
                ProfileId it = object;
                boolean bl = false;
                CompletableFuture completableFuture = dataLoader.load((Object)it);
                object = completableFuture;
                if (completableFuture != null) break block3;
            }
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            object = completableFuture;
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        }
        return object;
    }
}

