/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql;

import com.netflix.graphql.types.errors.ErrorDetail;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.connector.llm.exceptions.LlmApiException;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.graphql.CustomErrorDetail;
import de.justsoftware.admin.graphql.GraphQLExceptionHandler;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ResultPath;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.ibatis.exceptions.PersistenceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lde/justsoftware/admin/graphql/GraphQLExceptionHandler;", "Lgraphql/execution/DataFetcherExceptionHandler;", "<init>", "()V", "handleException", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/execution/DataFetcherExceptionHandlerResult;", "handlerParameters", "Lgraphql/execution/DataFetcherExceptionHandlerParameters;", "Companion", "admin-service"})
public class GraphQLExceptionHandler
implements DataFetcherExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;

    @Nullable
    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(@NotNull DataFetcherExceptionHandlerParameters handlerParameters) {
        Intrinsics.checkNotNullParameter((Object)handlerParameters, (String)"handlerParameters");
        Throwable exception = handlerParameters.getException();
        ResultPath path = handlerParameters.getPath();
        Throwable throwable = exception;
        TypedGraphQLError error = throwable instanceof IllegalArgumentException ? TypedGraphQLError.newBadRequestBuilder().path(path).build() : (throwable instanceof NotAllowedException ? TypedGraphQLError.newPermissionDeniedBuilder().path(path).build() : (throwable instanceof NotFoundException ? TypedGraphQLError.newNotFoundBuilder().path(path).build() : (throwable instanceof PersistenceException ? TypedGraphQLError.newInternalErrorBuilder().path(path).message("Something went wrong with the database communication").build() : (throwable instanceof SQLException ? TypedGraphQLError.newInternalErrorBuilder().path(path).message("Something went wrong with the database communication").build() : (throwable instanceof LlmApiException ? TypedGraphQLError.newBuilder().errorType(CustomErrorDetail.Companion.from((LlmApiException)exception).getErrorType()).path(path).message("Check error details").errorDetail((ErrorDetail)CustomErrorDetail.Companion.from((LlmApiException)exception)).build() : TypedGraphQLError.newInternalErrorBuilder().path(path).build())))));
        log.error("Exception while executing data fetcher for " + path + ": " + exception.getMessage(), exception);
        return CompletableFuture.completedFuture(DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)error).build());
    }

    static {
        Logger logger = LoggerFactory.getLogger(GraphQLExceptionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

