/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.news;

import com.netflix.graphql.dgs.client.MonoGraphQLClient;
import jakarta.servlet.http.HttpServletRequest;
import java.net.http.HttpClient;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.JdkClientHttpConnector;
import org.springframework.web.context.annotation.SessionScope;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/admin/connector/news/NewsAppConnectorConfig;", "", "newsGraphQlUrl", "", "<init>", "(Ljava/lang/String;)V", "newsAppGraphQlClient", "Lcom/netflix/graphql/dgs/client/MonoGraphQLClient;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "sslBundles", "Lorg/springframework/boot/ssl/SslBundles;", "admin-service"})
public class NewsAppConnectorConfig {
    @NotNull
    private final String newsGraphQlUrl;

    public NewsAppConnectorConfig(@Value(value="${just.news.graphql.url}") @NotNull String newsGraphQlUrl) {
        Intrinsics.checkNotNullParameter((Object)newsGraphQlUrl, (String)"newsGraphQlUrl");
        this.newsGraphQlUrl = newsGraphQlUrl;
    }

    @Bean
    @SessionScope
    @NotNull
    public MonoGraphQLClient newsAppGraphQlClient(@NotNull HttpServletRequest request, @NotNull SslBundles sslBundles) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)sslBundles, (String)"sslBundles");
        SSLContext sslContext = sslBundles.getBundle("just").createSslContext();
        HttpClient httpClient = HttpClient.newBuilder().sslContext(sslContext).build();
        WebClient webClient = WebClient.builder().baseUrl(this.newsGraphQlUrl).clientConnector((ClientHttpConnector)new JdkClientHttpConnector(httpClient)).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        WebClient webClient2 = webClient;
        return (MonoGraphQLClient)MonoGraphQLClient.Companion.createWithWebClient(webClient2, arg_0 -> NewsAppConnectorConfig.newsAppGraphQlClient$lambda$0(request, arg_0));
    }

    private static final void newsAppGraphQlClient$lambda$0(HttpServletRequest $request, HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.add("just-token", $request.getHeader("just-token"));
    }
}

