/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web.auth;

import de.justsoftware.admin.application.web.auth.AuthSettings;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.auth.AuthConnector;
import de.justsoftware.admin.graphql.generated.types.AuthSettingsInput;
import de.justsoftware.admin.id.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/admin/application/web/auth/AuthSettingsApplicationService;", "", "authConnector", "Lde/justsoftware/admin/connector/auth/AuthConnector;", "<init>", "(Lde/justsoftware/admin/connector/auth/AuthConnector;)V", "getAuthSettings", "Lde/justsoftware/admin/application/web/auth/AuthSettings;", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "updateAuthSettings", "", "authSettingsInput", "Lde/justsoftware/admin/graphql/generated/types/AuthSettingsInput;", "admin-service"})
public class AuthSettingsApplicationService {
    @NotNull
    private final AuthConnector authConnector;

    public AuthSettingsApplicationService(@NotNull AuthConnector authConnector) {
        Intrinsics.checkNotNullParameter((Object)authConnector, (String)"authConnector");
        this.authConnector = authConnector;
    }

    @NotNull
    public AuthSettings getAuthSettings(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getNonNullTenantId();
        authContext.checkTenantManager(tenantId);
        return new AuthSettings(tenantId, this.authConnector.getMfaMandatory(tenantId));
    }

    public void updateAuthSettings(@NotNull AuthorizationContext authContext, @NotNull AuthSettingsInput authSettingsInput) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Intrinsics.checkNotNullParameter((Object)authSettingsInput, (String)"authSettingsInput");
        TenantId tenantId = authContext.getNonNullTenantId();
        authContext.checkTenantManager(tenantId);
        if (authSettingsInput.getMfaMandatory() != null) {
            this.authConnector.setMfaMandatory(tenantId, authSettingsInput.getMfaMandatory().booleanValue());
        }
    }
}

