/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.content.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.content.ContentExtractionException;
import de.justsoftware.drive.content.ContentExtractionService;
import de.justsoftware.drive.content.KafkaConfigurationProvider;
import de.justsoftware.drive.content.kafka.AbstractKafkaConsumer;
import de.justsoftware.search.shared.SearchServiceInternalConnector;
import de.justsoftware.search.shared.model.JustSocialContentAtomicUpdateSolrDocument;
import de.justsoftware.search.shared.model.SearchableId;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Scope(scopeName="prototype")
@Service
public class ExtractionRunner
extends AbstractKafkaConsumer<String, String> {
    @VisibleForTesting
    static final String TOPIC = "just.search.index.content";
    private static final Logger LOG = LoggerFactory.getLogger(ExtractionRunner.class);
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    private final ContentExtractionService _extractionService;
    private final SearchServiceInternalConnector _searchSearchServiceInternalConnector;

    @Autowired
    public ExtractionRunner(KafkaConfigurationProvider kafkaConfigurationProvider, ContentExtractionService contentExtractionService, SearchServiceInternalConnector searchServiceInternalConnector) {
        this(kafkaConfigurationProvider.stringConsumer("just.drive.ContentExtractor", 1), contentExtractionService, searchServiceInternalConnector);
    }

    @VisibleForTesting
    ExtractionRunner(@Nullable Consumer<String, String> consumer, ContentExtractionService contentExtractionService, SearchServiceInternalConnector searchServiceInternalConnector) {
        super(consumer, TOPIC, THREAD_COUNTER.getAndIncrement());
        this._extractionService = contentExtractionService;
        this._searchSearchServiceInternalConnector = searchServiceInternalConnector;
    }

    protected Logger getLog() {
        return LOG;
    }

    protected int getPriority() {
        return 1;
    }

    protected void process(ConsumerRecords<String, String> records) {
        if (records.count() > 1) {
            LOG.error("this consumer can handle only a single object, but {} records should be processed", (Object)records.count());
        }
        for (ConsumerRecord record : records) {
            this.processRecord(record);
        }
    }

    @VisibleForTesting
    void processRecord(ConsumerRecord<String, String> record) {
        String value = (String)record.value();
        String key = (String)record.key();
        if (Strings.isNullOrEmpty((String)key)) {
            LOG.info("skipping record for value {} as document id is missing", (Object)value);
            return;
        }
        if (Strings.isNullOrEmpty((String)value)) {
            LOG.info("skipping record for key {} as storageId is missing", (Object)key);
            return;
        }
        LOG.info("processing {} - {}", (Object)key, (Object)value);
        this.commit();
        String content = this.getContent(key, value);
        this.sendContentToSearchService(key, content);
    }

    private void sendContentToSearchService(String documentId, @Nullable String content) {
        try {
            this._searchSearchServiceInternalConnector.indexSolrDocuments(List.of(new JustSocialContentAtomicUpdateSolrDocument(SearchableId.Companion.fromCanonicalId(documentId), content)));
        }
        catch (RuntimeException e) {
            LOG.error(String.format("error when sending content for documentId %s", documentId), (Throwable)e);
            throw new AbstractKafkaConsumer.StopProcessingException(String.format("error when sending content for documentId %s", documentId), (Throwable)e);
        }
    }

    private @Nullable String getContent(String key, String value) {
        StorageId storageId = new StorageId(value);
        try {
            return this._extractionService.parse(storageId);
        }
        catch (ContentExtractionException | RuntimeException e) {
            this.checkStorage(key, value, e);
            try {
                return this._extractionService.parse(storageId);
            }
            catch (ContentExtractionException | RuntimeException e2) {
                this.checkStorage(key, value, e2);
                LOG.error(String.format("storage is available but extraction failed while processing record: %s, %s", key, value), e2);
                return null;
            }
        }
    }

    private void checkStorage(String key, String value, Throwable e) {
        if (!this._extractionService.isStorageAvailable()) {
            throw new AbstractKafkaConsumer.StopProcessingException(String.format("storage is not available while processing record: %s, %s", key, value), e);
        }
    }
}

