#!/bin/sh

set -e

# Checks the health/routes endpoint of the gateway and echoes failed backends with status DOWN.
getRoutesStatus() {
    if health=$(curl -skL --connect-timeout 5 http://localhost:9099/gateway/internal/monitoring/health/routes); then
        STATUS=$(echo $health | jq '.status')

        if [ $STATUS != '"UP"' ]; then
            routes_that_are_down=$(echo $health | jq '[.components | to_entries[] | {"key": .key, "value": .value.status}][] | select(.value == "DOWN") | {(.key):.value}')
            echo $routes_that_are_down
            exit 2
        fi

        echo "All routes are UP"
        exit 0
    else
        echo "Endpoint not found on localhost."
        exit 2
    fi
}

getRoutesStatus
