/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.usergroup;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerState;
import de.justsoftware.people.business.event.InternalPublishAllUsergroupsEvent;
import de.justsoftware.people.business.usergroup.model.UserGroup;
import de.justsoftware.people.model.ItemType;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.UserGroupId;
import de.justsoftware.people.model.UserGroupRole;
import de.justsoftware.people.persistence.UserGroupMemberRepository;
import de.justsoftware.people.persistence.UserGroupRepository;
import de.justsoftware.people.persistence.UserGroupRoleRepository;
import de.justsoftware.people.persistence.model.DbUserGroup;
import de.justsoftware.people.persistence.model.DbUserGroupRole;
import de.justsoftware.permission.client.kafka.PermissionItemProducer;
import de.justsoftware.permission.client.kafka.SingleRoleAssignmentProducer;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
@Service
public class UserGroupPublisher {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(UserGroupPublisher.class);
    private final KafkaCleaningProducer<String, String> _kafkaProducer;
    private final UserGroupRepository _userGroupRepository;
    private final UserGroupMemberRepository _userGroupMemberRepository;
    private final UserGroupRoleRepository _userGroupRoleRepository;
    private final PermissionItemProducer _permissionItemProducer;
    private final SingleRoleAssignmentProducer _singleRoleAssignmentProducer;
    private final int _waitForOffsetsInS;

    @Autowired
    UserGroupPublisher(@Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> kafkaProducer, UserGroupRepository userGroupRepository, UserGroupMemberRepository userGroupMemberRepository, UserGroupRoleRepository userGroupRoleRepository, PermissionItemProducer permissionItemProducer, SingleRoleAssignmentProducer singleRoleAssignmentProducer, @Value(value="${just.people.userGroupPublisher.waitForOffsetsInS:10}") int waitForOffsetsInS) {
        this._kafkaProducer = kafkaProducer;
        this._userGroupRepository = userGroupRepository;
        this._userGroupMemberRepository = userGroupMemberRepository;
        this._userGroupRoleRepository = userGroupRoleRepository;
        this._permissionItemProducer = permissionItemProducer;
        this._singleRoleAssignmentProducer = singleRoleAssignmentProducer;
        this._waitForOffsetsInS = waitForOffsetsInS;
    }

    public void publishUserGroup(UserGroup userGroup, Consumer<WaitForOffsets> offsetsConsumer) {
        this.sendGroupToKafka(userGroup);
        offsetsConsumer.accept(this.publishGroupToPermission(userGroup));
    }

    public void publishUserGroupDeleted(UserGroupId deletedUserGroup, Set<ProfileId> deletedMembers) {
        this.sendToKafka("just.people.userGroup", deletedUserGroup.asString(), null);
        this._permissionItemProducer.publishDeletedItem(deletedUserGroup.asString());
        this.publishUserGroupMemberships(deletedUserGroup, (Set)ImmutableSet.of(), deletedMembers);
    }

    @Transactional
    @Async
    @EventListener
    public void onInternalPublishAllUserGroupsEvent(InternalPublishAllUsergroupsEvent event) throws InterruptedException {
        LOGGER.info("Republishing user group items to permission...");
        this._permissionItemProducer.republish(ItemType.USER_GROUP.name(), () -> this.forAllUserGroups(arg_0 -> this.publishGroupToPermission(arg_0)));
        LOGGER.info("Republishing user groups to kafka...");
        try (KafkaCleaningProducerState state = this._kafkaProducer.beginRefill(new String[]{"just.people.userGroup"});){
            this.forAllUserGroups(arg_0 -> this.sendGroupToKafka(arg_0));
            state.finishRefill();
        }
        LOGGER.info("Republishing user group memberships to kafka...");
        state = this._kafkaProducer.beginRefill(new String[]{"just.people.userGroupMembers"});
        try {
            this.forAllUserGroupMemberships((userGroup, member) -> this.sendGroupMembershipToKafka(userGroup, member, true));
            state.finishRefill();
        }
        finally {
            if (state != null) {
                state.close();
            }
        }
        LOGGER.info("Publishing profile visibilities and group memberships to permission...");
        this._singleRoleAssignmentProducer.republish(UserGroupPublisher.isProfileReaderRole().or(Role::isUserGroupRole), () -> this.forAllUserGroupMemberships((userGroupId, profileId) -> {
            this.publishProfileVisibility(userGroupId, profileId);
            this.publishUserGroupMembership(userGroupId, profileId);
        }));
        LOGGER.info("Publishing group permissions...");
        this._singleRoleAssignmentProducer.republishForAllItemRoles("USER_GROUP", () -> this.forAllUserGroups(group -> {
            UserGroupId userGroupId = group.getId();
            Map userGroupPermissions = this.getUserGroupRoles(userGroupId);
            userGroupPermissions.forEach((role, userGroupRole) -> this._singleRoleAssignmentProducer.addRoleReplacement(userGroupRole.toPermissionRole(userGroupId), role));
        }));
    }

    public boolean publishUserGroupMemberships(UserGroupId userGroupId, Set<ProfileId> membersToAdd, Set<ProfileId> membersToDelete) {
        Stream.Builder waitForOffsetsBuilder = Stream.builder();
        membersToAdd.forEach(member -> {
            this.sendGroupMembershipToKafka(userGroupId, member, true);
            waitForOffsetsBuilder.add(this.publishUserGroupMembership(userGroupId, member));
            waitForOffsetsBuilder.add(this.publishProfileVisibility(userGroupId, member));
        });
        membersToDelete.forEach(member -> {
            this.sendGroupMembershipToKafka(userGroupId, member, false);
            waitForOffsetsBuilder.add(this._singleRoleAssignmentProducer.deleteRoleReplacement(Role.userGroupRole((UUID)((UUID)userGroupId.getId())), Role.profileRole((long)((Long)member.getId()))));
            waitForOffsetsBuilder.add(this._singleRoleAssignmentProducer.deleteRoleReplacement(Role.reader((String)member.asString()), Role.read((String)userGroupId.asString())));
        });
        WaitForOffsets waitForOffsets = new WaitForOffsets(waitForOffsetsBuilder.build());
        boolean topicProcessed = waitForOffsets.waitForOffsets(Duration.ofSeconds(this._waitForOffsetsInS));
        if (!topicProcessed) {
            LOGGER.error("Offsets haven't been processed after {}s. There might be issues with visibilites. Consider raising the timeout. Continuing...", (Object)this._waitForOffsetsInS);
            return false;
        }
        return true;
    }

    public void publishUserGroupRoles(UserGroupId groupId, Map<Role, UserGroupRole> userGroupRolesToAdd, Map<Role, UserGroupRole> userGroupRolesToDelete, Consumer<WaitForOffsets> offsetsConsumer) {
        userGroupRolesToAdd.forEach((role, groupRole) -> offsetsConsumer.accept(this._singleRoleAssignmentProducer.addRoleReplacement(groupRole.toPermissionRole(groupId), role)));
        userGroupRolesToDelete.forEach((role, userGroupRole) -> offsetsConsumer.accept(this._singleRoleAssignmentProducer.deleteRoleReplacement(userGroupRole.toPermissionRole(groupId), role)));
    }

    @Nonnull
    private WaitForOffsets publishProfileVisibility(UserGroupId userGroupId, ProfileId p) {
        return this._singleRoleAssignmentProducer.addRoleReplacement(Role.reader((String)p.asString()), Role.read((String)userGroupId.asString()));
    }

    @Nonnull
    private WaitForOffsets publishUserGroupMembership(UserGroupId userGroupId, ProfileId p) {
        return this._singleRoleAssignmentProducer.addRoleReplacement(Role.userGroupRole((UUID)((UUID)userGroupId.getId())), Role.profileRole((long)((Long)p.getId())));
    }

    @Nonnull
    private WaitForOffsets publishGroupToPermission(UserGroup userGroup) {
        String parameter = userGroup.isAllTenantUsers() ? "ALL_TENANT_USERS" : (userGroup.isImported() ? "IMPORTED" : null);
        String userGroupId = userGroup.getId().asString();
        Optional<String> parent = Optional.of(userGroup.getTenantId().asString());
        return this._permissionItemProducer.publishItem(userGroupId, parent, new String[]{parameter});
    }

    private void sendGroupMembershipToKafka(UserGroupId userGroup, ProfileId member, boolean isMember) {
        this.sendToKafka("just.people.userGroupMembers", String.format("%s@%s", userGroup.asString(), member.asString()), String.valueOf(isMember));
    }

    private void sendGroupToKafka(UserGroup userGroup) {
        ObjectNode itemNode = JSON_MAPPER.createObjectNode();
        itemNode.set("name", (JsonNode)TextNode.valueOf((String)userGroup.getName()));
        itemNode.set("groupId", (JsonNode)TextNode.valueOf((String)userGroup.getId().toString()));
        itemNode.set("tenantId", (JsonNode)TextNode.valueOf((String)userGroup.getTenantId().toString()));
        itemNode.set("isAllTenantUsersGroup", (JsonNode)BooleanNode.valueOf((boolean)userGroup.isAllTenantUsers()));
        try {
            this.sendToKafka("just.people.userGroup", userGroup.getId().asString(), JSON_MAPPER.writeValueAsString((Object)itemNode));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void sendToKafka(String topic, String itemId, @Nullable String value) {
        this._kafkaProducer.send(new ProducerRecord(topic, (Object)itemId, (Object)value), (arg_0, arg_1) -> this.logErrorCallback(arg_0, arg_1));
    }

    private void logErrorCallback(RecordMetadata metadata, @Nullable Exception exception) {
        if (exception != null) {
            LOGGER.error("Could not publish group to topic " + metadata.topic(), (Throwable)exception);
        }
    }

    private void forAllUserGroups(Consumer<UserGroup> userGroupConsumer) {
        this._userGroupRepository.streamAll().forEach(dbUserGroup -> userGroupConsumer.accept(DbUserGroup.Companion.toUserGroup(dbUserGroup)));
    }

    private void forAllUserGroupMemberships(BiConsumer<UserGroupId, ProfileId> membershipConsumer) {
        this._userGroupMemberRepository.streamAll().forEach(userGroupMember -> membershipConsumer.accept(new UserGroupId(userGroupMember.getUserGroupId()), new ProfileId(userGroupMember.getProfileId())));
    }

    @Nonnull
    private Map<Role, UserGroupRole> getUserGroupRoles(UserGroupId userGroupId) {
        return this._userGroupRoleRepository.findAllByUserGroupIdIn((Collection)ImmutableSet.of((Object)((UUID)userGroupId.getId()))).stream().collect(Collectors.toMap(userGroupRole -> Role.create((String)userGroupRole.getRole()), DbUserGroupRole::getUserGroupRole));
    }

    @VisibleForTesting
    static Predicate<Role> isProfileReaderRole() {
        return role -> role.asString().startsWith("READER@PROFILE,");
    }
}

