/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.search.model.SearchField;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileAttributeConfig {
    public static final ProfileAttributeConfig FIRST_NAME = ProfileAttributeConfig.createForStaticAttribute((String)StaticAttributeName.firstName.name(), (boolean)true, (boolean)false, (SearchField)SearchField.Companion.getFirstName());
    public static final ProfileAttributeConfig LAST_NAME = ProfileAttributeConfig.createForStaticAttribute((String)StaticAttributeName.lastName.name(), (boolean)true, (boolean)false, (SearchField)SearchField.Companion.getLastName());
    public static final ProfileAttributeConfig TITLE = ProfileAttributeConfig.createForStaticAttribute((String)StaticAttributeName.title.name(), (boolean)false, (boolean)true, (SearchField)SearchField.Companion.getTitle());
    public static final ProfileAttributeConfig ADDITIONAL_TITLE = ProfileAttributeConfig.createForStaticAttribute((String)StaticAttributeName.additionalTitle.name(), (boolean)false, (boolean)true, (SearchField)SearchField.Companion.getAdditionalTitle());
    public static final ProfileAttributeConfig ACTIVE = ProfileAttributeConfig.createForStaticAttribute((String)StaticAttributeName.active.name(), (boolean)false, (boolean)true, null);
    private final AttributeType _type;
    private final String _name;
    private final boolean _visibleOnBadge;
    private final boolean _searchable;
    private final boolean _facetable;
    private final boolean _clickable;
    private final boolean _phoneNumber;
    private final Optional<SearchField> _searchField;
    private final ImmutableSetMultimap<String, String> _translatedValues;

    public ProfileAttributeConfig(AttributeType type, String name, boolean visibleOnBadge, boolean searchable, boolean facetable, boolean clickable, boolean phoneNumber, @Nullable SearchField searchField, ImmutableSetMultimap<String, String> translatedValues) {
        this._type = type;
        this._name = name;
        this._visibleOnBadge = visibleOnBadge;
        this._searchable = searchable;
        this._facetable = facetable;
        this._clickable = clickable;
        this._phoneNumber = phoneNumber;
        this._searchField = Optional.ofNullable(searchField);
        this._translatedValues = translatedValues;
    }

    @Nonnull
    private static ProfileAttributeConfig createForStaticAttribute(String attributeName, boolean visibleOnBadge, boolean facettable, @Nullable SearchField searchField) {
        return new ProfileAttributeConfig(AttributeType.TEXT, attributeName, visibleOnBadge, true, facettable, false, false, searchField, ImmutableSetMultimap.of());
    }

    @Nonnull
    public AttributeType getType() {
        return this._type;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public boolean isVisibleOnBadge() {
        return this._visibleOnBadge;
    }

    public boolean isSearchable() {
        return this._searchable;
    }

    public boolean isPhoneNumber() {
        return this._phoneNumber;
    }

    public boolean isFacetable() {
        return this._facetable;
    }

    public boolean isClickable() {
        return this._clickable;
    }

    @Nonnull
    public Optional<SearchField> getSearchField() {
        return this._searchField;
    }

    public boolean isSearchInFacetsSupported() {
        return this.isSearchable() && !this.isTranslated();
    }

    public boolean isTranslated() {
        return this._type == AttributeType.SELECT || this._type == AttributeType.CHECKRADIO;
    }

    @Nonnull
    public ImmutableSetMultimap<String, String> getTranslatedValues() {
        return this._translatedValues;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this._type).add("name", (Object)this._name).add("visibleOnBadge", this._visibleOnBadge).add("searchable", this._searchable).add("facetable", this._facetable).add("clickable", this._clickable).add("phoneNumber", this._phoneNumber).add("searchField", (Object)this._searchField).add("translatedValues", (Object)this._translatedValues).toString();
    }
}

