/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import de.justsoftware.notificationservice.business.InternalChatService;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/notificationservice/business/InternalChatService;", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Lorg/springframework/web/reactive/function/client/WebClient;)V", "getIosUnreadChatMessageCounts", "", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "", "profileIds", "", "Companion", "notification-service"})
@SourceDebugExtension(value={"SMAP\nInternalChatService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalChatService.kt\nde/justsoftware/notificationservice/business/InternalChatService\n+ 2 WebClientExtensions.kt\norg/springframework/web/reactive/function/client/WebClientExtensionsKt\n+ 3 LoggerUtils.kt\nde/justsoftware/notificationservice/util/LoggerUtilsKt\n*L\n1#1,36:1\n137#2:37\n8#3:38\n7#3,3:39\n*S KotlinDebug\n*F\n+ 1 InternalChatService.kt\nde/justsoftware/notificationservice/business/InternalChatService\n*L\n24#1:37\n33#1:38\n33#1:39,3\n*E\n"})
public class InternalChatService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private static final Logger LOG;

    public InternalChatService(@Qualifier(value="chatWebClient") @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.webClient = webClient;
    }

    @NotNull
    public Map<ProfileId, Long> getIosUnreadChatMessageCounts(@NotNull Set<? extends ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        if (profileIds.isEmpty()) {
            return MapsKt.emptyMap();
        }
        String[] stringArray = new String[]{"application/json"};
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)this.webClient.post().uri("/messages/unread/ios", new Object[0])).bodyValue(profileIds).header("Content-Type", stringArray).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        WebClient.ResponseSpec $this$bodyToMono$iv = responseSpec;
        boolean $i$f$bodyToMono = false;
        Mono mono = $this$bodyToMono$iv.bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"bodyToMono(object : Para\u2026zedTypeReference<T>() {})");
        Map map = (Map)mono.doOnError(arg_0 -> InternalChatService.getIosUnreadChatMessageCounts$lambda$1(InternalChatService::getIosUnreadChatMessageCounts$lambda$0, arg_0)).onErrorReturn((Object)MapsKt.emptyMap()).block();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private static final Unit getIosUnreadChatMessageCounts$lambda$0(Throwable e) {
        LOG.error("Error while retrieving unread chat message counts for iOS", e);
        return Unit.INSTANCE;
    }

    private static final void getIosUnreadChatMessageCounts$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

