/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.runtime.rest.entities.LoggerLevel;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loggers {
    private static final Logger log = LoggerFactory.getLogger(Loggers.class);
    private static final String ROOT_LOGGER_NAME = "root";
    private final Time time;
    private final Map<String, Long> lastModifiedTimes;

    public Loggers(Time time) {
        this.time = time;
        this.lastModifiedTimes = new HashMap<String, Long>();
    }

    public synchronized LoggerLevel level(String logger) {
        Objects.requireNonNull(logger, "Logger may not be null");
        org.apache.log4j.Logger foundLogger = null;
        if (ROOT_LOGGER_NAME.equalsIgnoreCase(logger)) {
            foundLogger = this.rootLogger();
        } else {
            Enumeration<org.apache.log4j.Logger> en = this.currentLoggers();
            while (en.hasMoreElements()) {
                org.apache.log4j.Logger l = en.nextElement();
                if (!logger.equals(l.getName())) continue;
                foundLogger = l;
                break;
            }
        }
        if (foundLogger == null) {
            log.warn("Unable to find level for logger {}", (Object)logger);
            return null;
        }
        return this.loggerLevel(foundLogger);
    }

    public synchronized Map<String, LoggerLevel> allLevels() {
        TreeMap<String, LoggerLevel> result = new TreeMap<String, LoggerLevel>();
        Enumeration<org.apache.log4j.Logger> enumeration = this.currentLoggers();
        Collections.list(enumeration).stream().filter(logger -> logger.getLevel() != null).forEach(logger -> result.put(logger.getName(), this.loggerLevel((org.apache.log4j.Logger)logger)));
        org.apache.log4j.Logger root = this.rootLogger();
        if (root.getLevel() != null) {
            result.put(ROOT_LOGGER_NAME, this.loggerLevel(root));
        }
        return result;
    }

    public synchronized List<String> setLevel(String namespace, Level level) {
        Objects.requireNonNull(namespace, "Logging namespace may not be null");
        Objects.requireNonNull(level, "Level may not be null");
        log.info("Setting level of namespace {} and children to {}", (Object)namespace, (Object)level);
        List<org.apache.log4j.Logger> childLoggers = this.loggers(namespace);
        ArrayList<String> result = new ArrayList<String>();
        for (org.apache.log4j.Logger logger : childLoggers) {
            this.setLevel(logger, level);
            result.add(logger.getName());
        }
        Collections.sort(result);
        return result;
    }

    private synchronized List<org.apache.log4j.Logger> loggers(String namespace) {
        Objects.requireNonNull(namespace, "Logging namespace may not be null");
        if (ROOT_LOGGER_NAME.equalsIgnoreCase(namespace)) {
            ArrayList<org.apache.log4j.Logger> result = Collections.list(this.currentLoggers());
            result.add(this.rootLogger());
            return result;
        }
        ArrayList<org.apache.log4j.Logger> result = new ArrayList<org.apache.log4j.Logger>();
        org.apache.log4j.Logger ancestorLogger = this.lookupLogger(namespace);
        Enumeration<org.apache.log4j.Logger> en = this.currentLoggers();
        boolean present = false;
        while (en.hasMoreElements()) {
            org.apache.log4j.Logger current = en.nextElement();
            if (current.getName().startsWith(namespace)) {
                result.add(current);
            }
            if (!namespace.equals(current.getName())) continue;
            present = true;
        }
        if (!present) {
            result.add(ancestorLogger);
        }
        return result;
    }

    org.apache.log4j.Logger lookupLogger(String logger) {
        return LogManager.getLogger((String)logger);
    }

    Enumeration<org.apache.log4j.Logger> currentLoggers() {
        return LogManager.getCurrentLoggers();
    }

    org.apache.log4j.Logger rootLogger() {
        return LogManager.getRootLogger();
    }

    private void setLevel(org.apache.log4j.Logger logger, Level level) {
        Level currentLevel = logger.getLevel();
        if (currentLevel == null) {
            currentLevel = logger.getEffectiveLevel();
        }
        if (level.equals((Object)currentLevel)) {
            log.debug("Skipping update for logger {} since its level is already {}", (Object)logger.getName(), (Object)level);
            return;
        }
        log.debug("Setting level of logger {} (excluding children) to {}", (Object)logger.getName(), (Object)level);
        logger.setLevel(level);
        this.lastModifiedTimes.put(logger.getName(), this.time.milliseconds());
    }

    private LoggerLevel loggerLevel(org.apache.log4j.Logger logger) {
        Level level = logger.getLevel();
        if (level == null) {
            level = logger.getEffectiveLevel();
        }
        Long lastModified = this.lastModifiedTimes.get(logger.getName());
        return new LoggerLevel(Objects.toString(level), lastModified);
    }
}

