/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.translation;

import com.deepl.api.AuthorizationException;
import com.deepl.api.ConnectionException;
import com.deepl.api.DeepLClient;
import com.deepl.api.NotFoundException;
import com.deepl.api.QuotaExceededException;
import com.deepl.api.TextResult;
import com.deepl.api.TextTranslationOptions;
import com.deepl.api.TooManyRequestsException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import de.justsoftware.wikiservice.kafka.model.KafkaTenant;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.translation.DeepLTranslationProvider;
import de.justsoftware.wikiservice.translation.TranslationProvider;
import de.justsoftware.wikiservice.translation.TranslationService;
import de.justsoftware.wikiservice.translation.model.TranslatableText;
import de.justsoftware.wikiservice.translation.model.TranslationErrorCode;
import de.justsoftware.wikiservice.translation.model.TranslationException;
import de.justsoftware.wikiservice.translation.model.TranslationResult;
import de.justsoftware.wikiservice.util.KafkaUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;
import org.springframework.web.server.PayloadTooLargeException;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0017J6\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0006H\u0016R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/wikiservice/translation/DeepLTranslationProvider;", "Lde/justsoftware/wikiservice/translation/TranslationProvider;", "<init>", "()V", "deepLAPIKeys", "Ljava/util/HashMap;", "Lde/justsoftware/wikiservice/model/TenantId;", "", "Lkotlin/collections/HashMap;", "onTenantChanged", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/wikiservice/kafka/model/KafkaTenant;", "translate", "", "Lde/justsoftware/wikiservice/translation/model/TranslationResult;", "texts", "Lde/justsoftware/wikiservice/translation/model/TranslatableText;", "sourceLanguage", "targetLanguage", "tenantId", "isTranslationEnabled", "", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nDeepLTranslationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeepLTranslationProvider.kt\nde/justsoftware/wikiservice/translation/DeepLTranslationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1863#2,2:139\n1557#2:141\n1628#2,3:142\n1557#2:145\n1628#2,3:146\n*S KotlinDebug\n*F\n+ 1 DeepLTranslationProvider.kt\nde/justsoftware/wikiservice/translation/DeepLTranslationProvider\n*L\n44#1:139,2\n74#1:141\n74#1:142,3\n89#1:145\n89#1:146,3\n*E\n"})
public class DeepLTranslationProvider
implements TranslationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<TenantId, String> deepLAPIKeys = new HashMap();
    private static final Logger LOG = LoggerFactory.getLogger(TranslationService.class);
    @NotNull
    public static final String TOPIC = "just.tenants";
    @NotNull
    private static final XmlMapper XML_MAPPER = new XmlMapper();

    @KafkaListener(id="tenantsDeepLKeyConsumer", containerFactory="tenantsDeeplKeyConsumerFactory", topics={"just.tenants"}, idIsGroup=false)
    public void onTenantChanged(@NotNull ConsumerRecords<TenantId, KafkaTenant> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$forEach$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            Object object2 = this;
            try {
                Object object3;
                String deepLKey;
                DeepLTranslationProvider $this$onTenantChanged_u24lambda_u242_u24lambda_u240 = object2;
                boolean bl2 = false;
                KafkaTenant kafkaTenant = (KafkaTenant)record.value();
                String string = deepLKey = kafkaTenant != null ? kafkaTenant.getDeeplKey() : null;
                if (deepLKey != null) {
                    ((Map)$this$onTenantChanged_u24lambda_u242_u24lambda_u240.deepLAPIKeys).put(record.key(), deepLKey);
                    object3 = Unit.INSTANCE;
                } else {
                    object3 = $this$onTenantChanged_u24lambda_u242_u24lambda_u240.deepLAPIKeys.remove(record.key());
                }
                object = Result.constructor-impl(object3);
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object error = object = throwable;
            boolean bl3 = false;
            Object[] objectArray = new Object[]{record.key(), record.offset(), error};
            LOG.error("Unable to update DeepL API key for TenantId {} at offset {}.", objectArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TranslationResult> translate(@NotNull List<TranslatableText> texts, @Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter(texts, (String)"texts");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        try {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            String string = (String)this.deepLAPIKeys.get(tenantId);
            if (string == null) {
                throw new IllegalStateException(("No DeepL API key for tenantId " + tenantId + ".").toString());
            }
            String deepLApiKey = string;
            DeepLClient deepLClient = new DeepLClient(deepLApiKey);
            Iterable $this$map$iv = texts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void translatableText;
                TranslatableText translatableText2 = (TranslatableText)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(XML_MAPPER.writeValueAsString((Object)translatableText.getText()));
            }
            List xmlTexts = (List)destination$iv$iv;
            TextTranslationOptions options = new TextTranslationOptions();
            options.setTagHandling("xml");
            List translations = deepLClient.translateText(xmlTexts, sourceLanguage, Companion.access$getDeepLSupportedTargetLanguage((Companion)Companion, (String)targetLanguage), options);
            MapType mapType = XML_MAPPER.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, String.class);
            Iterable iterable2 = texts;
            Intrinsics.checkNotNull((Object)translations);
            Iterable $this$map$iv2 = CollectionsKt.zip((Iterable)iterable2, (Iterable)translations);
            boolean $i$f$map2 = false;
            Iterable iterable3 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                TranslatableText translatableText = (TranslatableText)pair.component1();
                TextResult translationResult = (TextResult)pair.component2();
                Object object = XML_MAPPER.readValue(translationResult.getText(), (JavaType)mapType);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                LinkedHashMap translatedText = (LinkedHashMap)object;
                collection.add(new TranslationResult(translatableText.getTranslationId(), (Map)translatedText, translationResult.getDetectedSourceLanguage()));
            }
            return (List)destination$iv$iv2;
        }
        catch (Exception e) {
            TranslationErrorCode errorCode;
            Exception exception = e;
            TranslationErrorCode translationErrorCode = exception instanceof QuotaExceededException ? TranslationErrorCode.QUOTA_EXCEEDED : (exception instanceof TooManyRequestsException ? TranslationErrorCode.TOO_MANY_REQUESTS : (exception instanceof ConnectionException || exception instanceof NotFoundException ? TranslationErrorCode.PROVIDER_UNAVAILABLE : (exception instanceof AuthorizationException ? TranslationErrorCode.AUTHORIZATION_FAILED : (errorCode = exception instanceof PayloadTooLargeException ? TranslationErrorCode.PAYLOAD_TOO_LARGE : TranslationErrorCode.PROVIDER_INTERNAL_ERROR))));
            if (errorCode == TranslationErrorCode.PROVIDER_INTERNAL_ERROR) {
                LOG.error("Internal error occurred while translating via DeepL", (Throwable)e);
            }
            throw new TranslationException(errorCode, e.getMessage(), (Throwable)e);
        }
    }

    public boolean isTranslationEnabled(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return ((Map)this.deepLAPIKeys).containsKey(tenantId);
    }

    public static final /* synthetic */ XmlMapper access$getXML_MAPPER$cp() {
        return XML_MAPPER;
    }
}

