/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.persistence;

import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.persistence.DeletionFlagRepository;
import de.justsoftware.wikiservice.persistence.model.DbChapter;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import de.justsoftware.wikiservice.util.RepositoryUtilKt;
import jakarta.persistence.QueryHint;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH'J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H&J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H&J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H'J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH'J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH'J2\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0017J\u001c\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\f\u001a\u00020\u00032\b\b\u0001\u0010\u001c\u001a\u00020\u0003H'J\"\u0010\u001f\u001a\u00020\u001e2\u000e\b\u0001\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\b\b\u0001\u0010\u001c\u001a\u00020\u0003H'J\u001e\u0010!\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0017J*\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070#0\u000f2\u000e\b\u0001\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH'J\"\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0003H&J\u0016\u0010'\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0017J\u0016\u0010)\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH'J&\u0010*\u001a\u00020\u001e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-H\u0017J,\u0010.\u001a\u00020\u001e2\u000e\b\u0001\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\b\b\u0001\u0010+\u001a\u00020\u00072\b\b\u0001\u0010,\u001a\u00020-H'J0\u0010/\u001a\u00020\u001e2\b\b\u0001\u00100\u001a\u00020\u00032\b\b\u0001\u00101\u001a\u0002022\b\b\u0001\u00103\u001a\u0002042\b\b\u0001\u00105\u001a\u00020\u0003H'J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u000307H'J\u0018\u00108\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\b\b\u0001\u00109\u001a\u00020\u0003H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006:\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/wikiservice/persistence/ChapterRepository;", "Lde/justsoftware/wikiservice/persistence/DeletionFlagRepository;", "Lde/justsoftware/wikiservice/persistence/model/DbChapter;", "Ljava/util/UUID;", "findAllBySubscriber", "Lorg/springframework/data/domain/Page;", "subscriberId", "", "pageable", "Lorg/springframework/data/domain/Pageable;", "findAllByWikiId", "", "wikiId", "findAllByWikiIdAndDeletionIdIsNull", "findByDeletionIdIsNullAndIdIn", "", "chapterIds", "sort", "Lorg/springframework/data/domain/Sort;", "findByIds", "findByDeletionIdIsNullAndParentIdInOrderByTitle", "parentIds", "findByParentIdIn", "findByParentIds", "", "Lde/justsoftware/wikiservice/model/ParentId;", "findAllByParentIds", "deleteByWikiId", "deletionId", "markChaptersByWikiIdAsDeleted", "", "markChaptersByChapterIdsAsDeleted", "ids", "deleteByIds", "countByWikiIdIn", "Lkotlin/Pair;", "wikiIds", "countByWikiIds", "findAllByDeletionId", "deleteAllByDeletionIds", "deletionIds", "deleteAllByDeletionIdIn", "setUpdatedStatus", "updatedBy", "updatedAt", "Ljava/time/Instant;", "setUpdatedStatusIn", "updateParentIdAndPosition", "parentId", "parentType", "Lde/justsoftware/wikiservice/model/IdType;", "relativePosition", "", "id", "streamAllIds", "Ljava/util/stream/Stream;", "findAllDescendantChapterIds", "chapterId", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nChapterRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChapterRepository.kt\nde/justsoftware/wikiservice/persistence/ChapterRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,235:1\n1368#2:236\n1454#2,5:237\n1368#2:242\n1454#2,5:243\n1485#2:248\n1510#2,3:249\n1513#2,3:259\n1368#2:262\n1454#2,5:263\n1485#2:268\n1510#2,3:269\n1513#2,3:279\n1863#2,2:282\n1368#2:284\n1454#2,5:285\n1863#2,2:290\n1863#2,2:292\n381#3,7:252\n381#3,7:272\n*S KotlinDebug\n*F\n+ 1 ChapterRepository.kt\nde/justsoftware/wikiservice/persistence/ChapterRepository\n*L\n59#1:236\n59#1:237,5\n77#1:242\n77#1:243,5\n78#1:248\n78#1:249,3\n78#1:259,3\n87#1:262\n87#1:263,5\n88#1:268\n88#1:269,3\n88#1:279,3\n138#1:282,2\n157#1:284\n157#1:285,5\n167#1:290,2\n179#1:292,2\n78#1:252,7\n88#1:272,7\n*E\n"})
public interface ChapterRepository
extends DeletionFlagRepository<DbChapter, UUID> {
    @Query(value="SELECT c FROM DbChapter c INNER JOIN DbSubscription s ON (c.id = s.itemId AND s.itemType = 'WIKI_CHAPTER') AND s.isSubscribed = true AND s.subscriber = :subscriber AND c.deletionId is null")
    @NotNull
    public Page<DbChapter> findAllBySubscriber(@Param(value="subscriber") long var1, @NotNull Pageable var3);

    @NotNull
    public Set<DbChapter> findAllByWikiId(@NotNull UUID var1);

    @NotNull
    public Set<DbChapter> findAllByWikiIdAndDeletionIdIsNull(@NotNull UUID var1);

    @Deprecated(message="Use {@link #findByIds(ImmutableSet)} instead.")
    @NotNull
    public List<DbChapter> findByDeletionIdIsNullAndIdIn(@NotNull List<UUID> var1, @NotNull Sort var2);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<DbChapter> findByIds(@NotNull Set<UUID> chapterIds, @NotNull Sort sort) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(chapterIds, (String)"chapterIds");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)chapterIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List ids = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findByDeletionIdIsNullAndIdIn(ids, sort);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List findByIds$default(ChapterRepository chapterRepository, Set set, Sort sort, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findByIds");
        }
        if ((n & 2) != 0) {
            sort = RepositoryUtilKt.getChapterDefaultSort();
        }
        return chapterRepository.findByIds(set, sort);
    }

    @Deprecated(message="Use {@link #findByParentIds(ImmutableSet)} instead.")
    @NotNull
    public List<DbChapter> findByDeletionIdIsNullAndParentIdInOrderByTitle(@NotNull List<UUID> var1);

    @Deprecated(message="Use {@link #findAllByParentIds(ImmutableSet)} instead.")
    @NotNull
    public List<DbChapter> findByParentIdIn(@NotNull List<UUID> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<ParentId, List<DbChapter>> findByParentIds(@NotNull Set<UUID> parentIds, @NotNull Sort sort) {
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)parentIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean $i$f$findByParentIds$stub_for_inlining = false;
            boolean bl = false;
            list$iv$iv = this.findByDeletionIdIsNullAndParentIdInOrderByTitle(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DbChapter it = (DbChapter)element$iv$iv;
            boolean bl = false;
            ParentId key$iv$iv = IdUtilsKt.parentIdOf((UUID)it.getParentId(), (IdType)it.getParentType());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    public static /* synthetic */ Map findByParentIds$default(ChapterRepository chapterRepository, Set set, Sort sort, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findByParentIds");
        }
        if ((n & 2) != 0) {
            sort = RepositoryUtilKt.getChapterDefaultSort();
        }
        return chapterRepository.findByParentIds(set, sort);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<ParentId, List<DbChapter>> findAllByParentIds(@NotNull Set<UUID> parentIds) {
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)parentIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean $i$f$findAllByParentIds$stub_for_inlining$2 = false;
            boolean bl = false;
            list$iv$iv = this.findByParentIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DbChapter it = (DbChapter)element$iv$iv;
            boolean bl = false;
            ParentId key$iv$iv = IdUtilsKt.parentIdOf((UUID)it.getParentId(), (IdType)it.getParentType());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    @Transactional
    @NotNull
    default public Set<DbChapter> deleteByWikiId(@NotNull UUID wikiId, @NotNull UUID deletionId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        this.markChaptersByWikiIdAsDeleted(wikiId, deletionId);
        Unit $this$deleteByWikiId_u24lambda_u244 = Unit.INSTANCE;
        boolean bl = false;
        return this.findAllByDeletionId(deletionId);
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteByWikiId(WikiId, DeletionId)} instead.")
    @Modifying
    @Query(value="\n            UPDATE DbChapter c\n            SET c.deletionId = :deletionId\n            WHERE c.deletionId is null AND c.wikiId = :wikiId\n        ")
    public void markChaptersByWikiIdAsDeleted(@Param(value="wikiId") @NotNull UUID var1, @Param(value="deletionId") @NotNull UUID var2);

    @Deprecated(message="Do not use this function directly. Use {@link #deleteByIds(Set)} instead.")
    @Modifying
    @Query(value="\n       UPDATE DbChapter c\n       SET c.deletionId = :deletionId\n       WHERE c.deletionId is null AND c.id IN :ids\n    ")
    public void markChaptersByChapterIdsAsDeleted(@Param(value="ids") @NotNull List<UUID> var1, @Param(value="deletionId") @NotNull UUID var2);

    @Transactional
    default public void deleteByIds(@NotNull Set<UUID> ids, @NotNull UUID deletionId) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)ids, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.markChaptersByChapterIdsAsDeleted(it, deletionId);
        }
    }

    @Deprecated(message="Do not use this function directly. Use {@link #countByWikiIds(Set)} instead.")
    @Query(value="\n       SELECT new kotlin.Pair(c.wikiId, count(c))\n       FROM DbChapter c\n       WHERE c.wikiId in :wikiIds\n       AND c.deletionId is null\n       GROUP BY wikiId\n    ")
    @NotNull
    public List<Pair<UUID, Long>> countByWikiIdIn(@Param(value="wikiIds") @NotNull List<UUID> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<UUID, Long> countByWikiIds(@NotNull Set<UUID> wikiIds) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)wikiIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean $i$f$countByWikiIds$stub_for_inlining$6 = false;
            boolean bl = false;
            Iterable list$iv$iv = this.countByWikiIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Set<DbChapter> findAllByDeletionId(@NotNull UUID var1);

    @Transactional
    default public void deleteAllByDeletionIds(@NotNull Set<UUID> deletionIds) {
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)deletionIds, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.deleteAllByDeletionIdIn(it);
        }
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteAllByDeletionIds(Set)} instead.")
    public void deleteAllByDeletionIdIn(@NotNull List<UUID> var1);

    /*
     * WARNING - void declaration
     */
    @Transactional
    default public void setUpdatedStatus(@NotNull Set<UUID> chapterIds, long updatedBy, @NotNull Instant updatedAt) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(chapterIds, (String)"chapterIds");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Iterable iterable = CollectionsKt.chunked((Iterable)chapterIds, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.setUpdatedStatusIn(it, updatedBy, updatedAt);
        }
    }

    @Deprecated(message="Do not use this function directly. Use {@link #setUpdatedStatus(Set, ProfileId, Instant)} instead.")
    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="\n            UPDATE DbChapter c\n            SET c.updatedAt = :updatedAt,\n                c.modifiedBy = :updatedBy\n            WHERE c.id IN :chapterIds\n        ")
    public void setUpdatedStatusIn(@Param(value="chapterIds") @NotNull List<UUID> var1, @Param(value="updatedBy") long var2, @Param(value="updatedAt") @NotNull Instant var4);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="\n            UPDATE DbChapter c\n            SET c.parentId = :parentId,\n                c.parentType = :parentType,\n                c.relativePosition = :relativePosition\n            WHERE c.id = :id\n        ")
    public void updateParentIdAndPosition(@Param(value="parentId") @NotNull UUID var1, @Param(value="parentType") @NotNull IdType var2, @Param(value="relativePosition") int var3, @Param(value="id") @NotNull UUID var4);

    @Query(value="SELECT c.id FROM DbChapter c")
    @QueryHints(value={@QueryHint(value="1000", name="org.hibernate.fetchSize")})
    @NotNull
    public Stream<UUID> streamAllIds();

    @Query(value="\n        WITH RECURSIVE chapter_hierarchy(id) AS (\n            SELECT id FROM chapter c WHERE c.id = :chapterId\n            UNION ALL\n            SELECT c.id FROM chapter c\n            INNER JOIN chapter_hierarchy ch ON c.parent_id = ch.id\n            AND c.deletion_id IS NULL\n        )\n        SELECT id FROM chapter_hierarchy WHERE id != :chapterId;\n        ", nativeQuery=true)
    @NotNull
    public List<UUID> findAllDescendantChapterIds(@Param(value="chapterId") @NotNull UUID var1);
}

