/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.ai.chatbot.controller;

import de.justsoftware.wikiservice.ai.chatbot.business.RagAssistant;
import de.justsoftware.wikiservice.ai.chatbot.business.RagAssistantFactory;
import de.justsoftware.wikiservice.ai.chatbot.controller.ChatRequest;
import de.justsoftware.wikiservice.ai.chatbot.controller.ChatResponse;
import de.justsoftware.wikiservice.authorization.AuthContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/experimental/rag"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/wikiservice/ai/chatbot/controller/ExperimentalRagController;", "", "assistantFactory", "Lde/justsoftware/wikiservice/ai/chatbot/business/RagAssistantFactory;", "<init>", "(Lde/justsoftware/wikiservice/ai/chatbot/business/RagAssistantFactory;)V", "chat", "Lde/justsoftware/wikiservice/ai/chatbot/controller/ChatResponse;", "req", "Lde/justsoftware/wikiservice/ai/chatbot/controller/ChatRequest;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "wiki-service"})
public class ExperimentalRagController {
    @NotNull
    private final RagAssistantFactory assistantFactory;

    public ExperimentalRagController(@NotNull RagAssistantFactory assistantFactory) {
        Intrinsics.checkNotNullParameter((Object)assistantFactory, (String)"assistantFactory");
        this.assistantFactory = assistantFactory;
    }

    @PostMapping(value={"/chat"})
    @NotNull
    public ChatResponse chat(@RequestBody @NotNull ChatRequest req, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        RagAssistant assistant = this.assistantFactory.create(authContext);
        String answer = assistant.chat(req.getChatId(), req.getMessage());
        return new ChatResponse(answer);
    }
}

