/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.ai.chatbot.business;

import de.justsoftware.wikiservice.ai.assistant.kafka.KafkaTenantAiSettingsConsumer;
import de.justsoftware.wikiservice.ai.chatbot.business.InMemoryChatMemoryProvider;
import de.justsoftware.wikiservice.ai.chatbot.business.RagAssistant;
import de.justsoftware.wikiservice.ai.chatbot.business.SemanticSearchTools;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.model.TenantId;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.service.AiServices;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/wikiservice/ai/chatbot/business/RagAssistantFactory;", "", "tenantConsumer", "Lde/justsoftware/wikiservice/ai/assistant/kafka/KafkaTenantAiSettingsConsumer;", "memoryProvider", "Lde/justsoftware/wikiservice/ai/chatbot/business/InMemoryChatMemoryProvider;", "searchRestClient", "Lorg/springframework/web/client/RestClient;", "<init>", "(Lde/justsoftware/wikiservice/ai/assistant/kafka/KafkaTenantAiSettingsConsumer;Lde/justsoftware/wikiservice/ai/chatbot/business/InMemoryChatMemoryProvider;Lorg/springframework/web/client/RestClient;)V", "create", "Lde/justsoftware/wikiservice/ai/chatbot/business/RagAssistant;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "wiki-service"})
public class RagAssistantFactory {
    @NotNull
    private final KafkaTenantAiSettingsConsumer tenantConsumer;
    @NotNull
    private final InMemoryChatMemoryProvider memoryProvider;
    @NotNull
    private final RestClient searchRestClient;

    public RagAssistantFactory(@NotNull KafkaTenantAiSettingsConsumer tenantConsumer, @NotNull InMemoryChatMemoryProvider memoryProvider, @Qualifier(value="searchRestClient") @NotNull RestClient searchRestClient) {
        Intrinsics.checkNotNullParameter((Object)tenantConsumer, (String)"tenantConsumer");
        Intrinsics.checkNotNullParameter((Object)memoryProvider, (String)"memoryProvider");
        Intrinsics.checkNotNullParameter((Object)searchRestClient, (String)"searchRestClient");
        this.tenantConsumer = tenantConsumer;
        this.memoryProvider = memoryProvider;
        this.searchRestClient = searchRestClient;
    }

    @NotNull
    public RagAssistant create(@NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getTenantId();
        ChatModel chatModel = this.tenantConsumer.getChatModel(tenantId);
        if (chatModel == null) {
            throw new IllegalStateException(("No LLM configured for tenant=" + tenantId).toString());
        }
        ChatModel chatModel2 = chatModel;
        SemanticSearchTools tools = new SemanticSearchTools(this.searchRestClient, 0.0, 2, null);
        Object[] objectArray = new Object[]{tools};
        Object object = AiServices.builder(RagAssistant.class).chatModel(chatModel2).chatMemoryProvider((ChatMemoryProvider)this.memoryProvider).tools(objectArray).maxSequentialToolsInvocations(2).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (RagAssistant)object;
    }
}

