/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.ai.assistant.business;

import de.justsoftware.wikiservice.ai.assistant.business.AiAssistantService;
import de.justsoftware.wikiservice.ai.assistant.util.ThinkFilter;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001a\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0012\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/wikiservice/ai/assistant/business/AiAssistantService;", "", "<init>", "()V", "generateText", "Lde/justsoftware/wikiservice/ai/assistant/business/AiAssistantService$StreamHandle;", "instruction", "", "text", "streamingChatModel", "Ldev/langchain4j/model/chat/StreamingChatModel;", "onToken", "Lkotlin/Function1;", "", "onComplete", "Lkotlin/Function0;", "onError", "", "generatePrompt", "Companion", "StreamHandle", "wiki-service"})
public class AiAssistantService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = LoggerFactory.getLogger(AiAssistantService.class);
    @NotNull
    private static final String WRITE_ASSISTANT_SYSTEM_PROMPT = "You are a professional writing assistant.\n\nYour task is to generate **only valid Markdown output** \u2014 without any commentary, explanation, or code block wrappers.\nYou are not allowed to explain or reason. You only return the Markdown content.\n\nStrict Markdown formatting rules:\n- Use **valid Markdown syntax only**. Do not use HTML.\n- After each heading line (e.g. `#`, `##`), insert **two line breaks** before continuing with the body text.\n- Only use plain text in headings.\n- Only use headings up to level 3.\n- Paragraphs and block elements (e.g. lists, quotes, tables) must be separated by a **blank line**.\n- Do not combine heading and paragraph content on the same line.\n- Use standard Markdown formatting for emphasis: **bold**, *italic*, [links](https://example.com \"link title\").\n- **Always** use a title in links. This should always correspond to the plain text used in square brackets.\n- **Never wrap the output in a code block** (like ```markdown ... ```).\n- Do not include any explanation, thoughts, or reasoning \u2014 just the final Markdown output.\n\nCustom Markdown formats (preserve delimiters; translate/edit only inner text):\n1) Underline: `==text==` \u2014 You may move or split this span as needed for grammar or translation.\n2) Color: `{color:NAME}text{color}` \u2014 You may change `NAME` if the task requires a color change. Valid values for `NAME` are `orange`, `red`, `purple`, `blue` and `green`. Do not use any other than these values for `color`.\n3) Background color: `{background_color:NAME}text{background_color}` \u2014 You may change `NAME` if the task requires a background color change. Valid values for `NAME` are `gray`, `orange`, `red`, `blue` and `green`. Do not use any other than these values for `background_color`.\n- Keep all other unknown markup exactly unchanged.\n- Keep tags balanced and properly nested when editing.\n- You may move or split these spans to match natural grammar and style in the output language.\n\n## Examples\n\n### Example 1 \u2014 Moving underline in translation\n**Input:**\nIch bin in den Park **==gegangen==**.\n**Task:** Translate into English.\n**Output:**\nI **==went==** to the park.\n\n### Example 2 \u2014 Changing a color\n**Input:**\nIch esse {color:green}\u00c4pfel{color} und Birnen.\n**Task:** Translate into English and make all apples red.\n**Output:**\nI eat {color:red}apples{color} and pears.\n\n### Example 3 \u2014 Preserving unknown markup\n**Input:**\nHeute ist ein {custom:blue}besonderer Tag{custom}.\n**Task:** Translate into English.\n**Output:**\nToday is a {custom:blue}special day{custom}.\n\nOutput only the Markdown document. Nothing else.";

    @NotNull
    public StreamHandle generateText(@NotNull String instruction, @Nullable String text, @NotNull StreamingChatModel streamingChatModel, @NotNull Function1<? super String, Unit> onToken, @NotNull Function0<Unit> onComplete, @NotNull Function1<? super Throwable, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)streamingChatModel, (String)"streamingChatModel");
        Intrinsics.checkNotNullParameter(onToken, (String)"onToken");
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        String prompt = this.generatePrompt(instruction, text);
        AtomicBoolean cancelled = new AtomicBoolean(false);
        ThinkFilter filter = new ThinkFilter();
        streamingChatModel.chat(prompt, (StreamingChatResponseHandler)new /* Unavailable Anonymous Inner Class!! */);
        return new StreamHandle(() -> AiAssistantService.generateText$lambda$0(cancelled));
    }

    private String generatePrompt(String instruction, String text) {
        StringBuilder stringBuilder;
        StringBuilder $this$generatePrompt_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$generatePrompt_u24lambda_u241.append(WRITE_ASSISTANT_SYSTEM_PROMPT);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$generatePrompt_u24lambda_u241.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$generatePrompt_u24lambda_u241.append("Instruction:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$generatePrompt_u24lambda_u241.append(instruction);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        CharSequence charSequence = text;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$generatePrompt_u24lambda_u241.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder5 = $this$generatePrompt_u24lambda_u241.append("Text:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder6 = $this$generatePrompt_u24lambda_u241.append(text);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
    }

    private static final Unit generateText$lambda$0(AtomicBoolean $cancelled) {
        if ($cancelled.compareAndSet(false, true)) {
            LOG.info("LLM stream cancelled.");
        }
        return Unit.INSTANCE;
    }
}

