/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.ai.assistant.application;

import de.justsoftware.wikiservice.ai.assistant.business.AiAssistantService;
import de.justsoftware.wikiservice.ai.assistant.config.AiAssistantConfig;
import de.justsoftware.wikiservice.ai.assistant.kafka.KafkaTenantAiSettingsConsumer;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.model.TenantId;
import dev.langchain4j.model.chat.StreamingChatModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJX\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/wikiservice/ai/assistant/application/AiAssistantApplicationService;", "", "aiAssistantService", "Lde/justsoftware/wikiservice/ai/assistant/business/AiAssistantService;", "aiAssistantConfig", "Lde/justsoftware/wikiservice/ai/assistant/config/AiAssistantConfig;", "kafkaTenantAiSettingsConsumer", "Lde/justsoftware/wikiservice/ai/assistant/kafka/KafkaTenantAiSettingsConsumer;", "<init>", "(Lde/justsoftware/wikiservice/ai/assistant/business/AiAssistantService;Lde/justsoftware/wikiservice/ai/assistant/config/AiAssistantConfig;Lde/justsoftware/wikiservice/ai/assistant/kafka/KafkaTenantAiSettingsConsumer;)V", "generateText", "Lde/justsoftware/wikiservice/ai/assistant/business/AiAssistantService$StreamHandle;", "instruction", "", "text", "onToken", "Lkotlin/Function1;", "", "onComplete", "Lkotlin/Function0;", "onError", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "wiki-service"})
public class AiAssistantApplicationService {
    @NotNull
    private final AiAssistantService aiAssistantService;
    @NotNull
    private final AiAssistantConfig aiAssistantConfig;
    @NotNull
    private final KafkaTenantAiSettingsConsumer kafkaTenantAiSettingsConsumer;

    public AiAssistantApplicationService(@NotNull AiAssistantService aiAssistantService, @NotNull AiAssistantConfig aiAssistantConfig, @NotNull KafkaTenantAiSettingsConsumer kafkaTenantAiSettingsConsumer) {
        Intrinsics.checkNotNullParameter((Object)aiAssistantService, (String)"aiAssistantService");
        Intrinsics.checkNotNullParameter((Object)aiAssistantConfig, (String)"aiAssistantConfig");
        Intrinsics.checkNotNullParameter((Object)kafkaTenantAiSettingsConsumer, (String)"kafkaTenantAiSettingsConsumer");
        this.aiAssistantService = aiAssistantService;
        this.aiAssistantConfig = aiAssistantConfig;
        this.kafkaTenantAiSettingsConsumer = kafkaTenantAiSettingsConsumer;
    }

    @NotNull
    public AiAssistantService.StreamHandle generateText(@NotNull String instruction, @Nullable String text, @NotNull Function1<? super String, Unit> onToken, @NotNull Function0<Unit> onComplete, @NotNull Function1<? super Throwable, Unit> onError, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter(onToken, (String)"onToken");
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!this.aiAssistantConfig.getAllowAiAssistant()) {
            boolean $i$a$-require-AiAssistantApplicationService$generateText$22 = false;
            String $i$a$-require-AiAssistantApplicationService$generateText$22 = "AI assistant is not enabled.";
            throw new IllegalArgumentException($i$a$-require-AiAssistantApplicationService$generateText$22.toString());
        }
        TenantId tenantId = authContext.getTenantId();
        StreamingChatModel streamingChatModel = this.kafkaTenantAiSettingsConsumer.getStreamingChatModel(tenantId);
        if (streamingChatModel == null) {
            throw new IllegalArgumentException("There are no AI assistant login details for tenant " + tenantId + ".");
        }
        StreamingChatModel streamingChatModel2 = streamingChatModel;
        return this.aiAssistantService.generateText(instruction, text, streamingChatModel2, onToken, onComplete, onError);
    }
}

