/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.configuration;

import com.freiheit.toro.server.CacheFilter;
import de.justsoftware.onx.common.presentation.server.JucoLocaleResolver;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.http.CacheControl;
import org.springframework.web.multipart.support.MultipartFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.WebContentInterceptor;
import org.wings.session.WingServlet;

@Configuration
@ImportResource(value={"classpath*:springmvc-servlet.xml"})
@EnableWebMvc
@ParametersAreNonnullByDefault
public class ToroWebConfig
implements WebMvcConfigurer {
    private final JucoLocaleResolver _jucoLocaleResolver;

    public ToroWebConfig(JucoLocaleResolver jucoLocaleResolver) {
        this._jucoLocaleResolver = jucoLocaleResolver;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this._jucoLocaleResolver);
        WebContentInterceptor cachingInterceptor = new WebContentInterceptor();
        cachingInterceptor.setCacheControl(CacheControl.noStore());
        registry.addInterceptor((HandlerInterceptor)cachingInterceptor).addPathPatterns(new String[]{"/rest/**"});
    }

    @Bean
    @Nonnull
    public FilterRegistrationBean<CacheFilter> cacheFilter() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setFilter((Filter)new CacheFilter());
        filterRegistration.addUrlPatterns(new String[]{"/www/*"});
        return filterRegistration;
    }

    @Bean
    @Nonnull
    public FilterRegistrationBean<MultipartFilter> multipartFilter() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setOrder(-101);
        MultipartFilter filter = new MultipartFilter();
        filter.setMultipartResolverBeanName("multipartResolver");
        filterRegistration.setFilter((Filter)filter);
        filterRegistration.addUrlPatterns(new String[]{"/upload/entity"});
        return filterRegistration;
    }

    @Bean
    @Order(value=-2147483599)
    @Primary
    public FilterRegistrationBean<Filter> filter(@Qualifier(value="justSessionRepositoryFilter") Filter sessionFilter) {
        FilterRegistrationBean reg = new FilterRegistrationBean();
        reg.setFilter(sessionFilter);
        reg.setOrder(-2147483599);
        reg.addUrlPatterns(new String[]{"/config/*"});
        return reg;
    }

    @Bean
    @Nonnull
    public ServletRegistrationBean<HttpServlet> superopertyServlet() {
        ServletRegistrationBean superopertyServlet = new ServletRegistrationBean();
        WingServlet wingsServlet = new WingServlet();
        superopertyServlet.addInitParameter("wings.mainclass", "com.freiheit.toro.admin.presentation.AdminServlet");
        superopertyServlet.addInitParameter("wings.lookandfeel.default", "org.wings.plaf.css.CSSLookAndFeel");
        superopertyServlet.setServlet((Servlet)wingsServlet);
        superopertyServlet.addUrlMappings(new String[]{"/config/*"});
        superopertyServlet.setLoadOnStartup(3);
        return superopertyServlet;
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseTrailingSlashMatch(Boolean.valueOf(true));
    }
}

