/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.storageserver.controller;

import de.justsoftware.storageserver.service.FileManagementException;
import de.justsoftware.storageserver.service.FileManagementService;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/fileManagementServices"})
public class FileManagementController {
    private static final String OK = "ok";
    private static final Logger LOG = LoggerFactory.getLogger(FileManagementController.class);
    private final FileManagementService _fileManagementService;

    @Autowired
    public FileManagementController(FileManagementService fileManagementService) {
        this._fileManagementService = fileManagementService;
    }

    @PostMapping(params={"action=saveFile"})
    public String saveFile(@RequestPart(value="basePath") String basePath, @RequestPart(value="fileStream") MultipartFile fileStream) throws IOException {
        this._fileManagementService.checkFreeSpace(fileStream.getSize());
        String filename = fileStream.getOriginalFilename();
        if (filename == null) {
            throw new FileManagementException("No file name specified.");
        }
        File targetDir = this._fileManagementService.ensureDirectory(basePath);
        File targetFile = new File(targetDir, filename);
        fileStream.transferTo(targetFile);
        try {
            this._fileManagementService.ensureFilePermissions(targetFile);
        }
        catch (IOException e) {
            LOG.error("Error setting file permissions", (Throwable)e);
        }
        return OK;
    }

    @PostMapping(params={"action=deleteFile"})
    public String deleteFile(@RequestParam(value="basePath") String basePath, @RequestParam(value="filename") String filename) throws IOException {
        this._fileManagementService.deleteFile(basePath, filename);
        return OK;
    }

    @PostMapping(params={"action=trashFile"})
    public String trashFile(@RequestParam(value="basePath") String basePath, @RequestParam(value="filename") String filename) throws IOException {
        this._fileManagementService.moveFileToTrash(basePath, filename);
        return OK;
    }

    @PostMapping(params={"action=deleteDir"})
    public String deleteDir(@RequestParam(value="basePath") String basePath) throws IOException {
        this._fileManagementService.deleteDirectory(basePath);
        return OK;
    }

    @PostMapping(params={"action=copyFile"})
    public String copyFile(@RequestParam(value="src") String srcPath, @RequestParam(value="dest") String destPath) throws IOException {
        this._fileManagementService.copyFile(srcPath, destPath);
        return OK;
    }

    @PostMapping(params={"action=moveFile"})
    public String moveFile(@RequestParam(value="src") String srcPath, @RequestParam(value="dest") String destPath) throws IOException {
        this._fileManagementService.moveFile(srcPath, destPath);
        return OK;
    }

    @ExceptionHandler(value={IOException.class, FileManagementException.class})
    public @Nullable String handleException(HttpServletRequest request, Exception e) {
        LOG.error("Error handling action {}", (Object)request.getParameter("action"), (Object)e);
        return e.getMessage();
    }
}

