/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.storageserver;

import de.justsoftware.storageserver.service.FileManagementService;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.CacheControl;

@Configuration
public class TomcatConfigurer
implements WebServerFactoryCustomizer<TomcatServletWebServerFactory> {
    private static final int ONE_WEEK_IN_DAYS = 7;
    private final FileManagementService _fileManagementService;

    @Autowired
    public TomcatConfigurer(FileManagementService fileManagementService) {
        this._fileManagementService = fileManagementService;
    }

    public void customize(TomcatServletWebServerFactory factory) {
        factory.setDocumentRoot(this._fileManagementService.getFilesPath());
    }

    @Bean
    public Filter cacheControlFilter() {
        return (request, response, chain) -> {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (!httpRequest.getRequestURI().contains("/images")) {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
            boolean isAppLogoOrDefaultImage = httpRequest.getRequestURI().contains("/customAppSwitcherLogo/") || httpRequest.getRequestURI().contains("default");
            Duration cacheDuration = isAppLogoOrDefaultImage ? Duration.ofHours(1L) : Duration.ofDays(7L);
            String cacheControlValue = CacheControl.maxAge((Duration)cacheDuration).cachePrivate().noTransform().mustRevalidate().getHeaderValue();
            httpResponse.addHeader("Cache-Control", cacheControlValue);
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        };
    }
}

