## Authentication and Authorisation

We only support **OAuth 2.0 flows** for authentication purposes.

Supported flows:

- Authorization Code Flow
- Client Credentials Flow
- Password Flow

Available API routes will describe what flow they support as some are bound to have a specific user attached to the
previously obtained *access_token*.

 **Warning**: the **access_token** for the **Authorization Code Flow** and **Password Flow** are **not limited** and allow
a 3rd party application **full access** on the Just Social platform in the context of the logged in user!

## OAuth Request URLs
All data has to be `application/x-www-form-urlencoded` in the body of the requests.

**Token URL:**          `https://$WEB_DOMAIN/auth/oauth2/token`  
**Authorization URL:**  `https://$WEB_DOMAIN/auth/oauth2/authorize`

## Obtaining API access

If you need an API access please contact our support via [support@just.social](mailto:support@just.social) and tell us what APIs you need access to.  
If you want to use the **Authorization Code Flow** you will also need to provide a **redirect_uri**.

You will be given credentials in the form of **client_id** and **client_secret** over an encrypted channel.

**Warning**: These channels are only accessible once!

If you are using the OAuth2 **Authorization Code Flow** or **Password Flow** you also need your **user credentials** for $WEB_DOMAIN.

### OAuth2 Password Flow example
username: `my.justuser@domain.tld`  
password: `my_password`  
client_id: `my_client_id`  
client_secret: `my_client_secret`  
scopes: `user:prople.read`, `user:wiki.read`

**Command Line Request**
```
curl -X POST https://$WEB_DOMAIN/auth/oauth2/token 
  -H "Content-Type: application/x-www-form-urlencoded"
  -d "grant_type=password&username=my.justuser%40domain.tld&password=my_password&client_id=my_client_id&client_secret=my_client_secret&scope=user%3Apeople.read%20user%3Awiki.read" 
```
**Result**
```
{"access_token":"cJMSl0BOYmBeQ4ppCuH-1D98-46hSmU_7M86gDqUrh0rmndekmpwtPWR0H1fiMMqh13HJGPge2dFrKFing3-Q6mPyDpdD51q1fkOKjVwVxq8WOfXNoti0lVOEJCCqd0W","scope":"user:people.read,user:wiki.read","token_type":"Bearer","expires_in":3599}
```
