--liquibase formatted sql

--changeset bjrke:create_table_role_assignment
CREATE TABLE role_replacement (
    role VARCHAR(511) NOT NULL,
    replacement VARCHAR(511) NOT NULL,
    profile_replacement BOOL NOT NULL,

    ctime TIMESTAMP DEFAULT now() NOT NULL,

    PRIMARY KEY (replacement, role)
);

--changeset bjrke:create_table_node_state
CREATE TABLE node_state (
    key_col VARCHAR(4000) NOT NULL,
    value_col VARCHAR(4000) NOT NULL,

    ctime TIMESTAMP DEFAULT now() NOT NULL,
    mtime TIMESTAMP DEFAULT now() NOT NULL,

    PRIMARY KEY (key_col)
);

--changeset mdoelle:create_table_item
CREATE TABLE item (
    id VARCHAR(255) PRIMARY KEY,
    parent_id VARCHAR(255),

    ctime TIMESTAMP DEFAULT now() NOT NULL,
    mtime TIMESTAMP DEFAULT now() NOT NULL
);

--changeset mdoelle:create_table_item_param
CREATE TABLE item_param (
    item_id VARCHAR(255) NOT NULL,
    param VARCHAR(511) NOT NULL,

    ctime TIMESTAMP DEFAULT now() NOT NULL,
    mtime TIMESTAMP DEFAULT now() NOT NULL,

    PRIMARY KEY (item_id, param),
    CONSTRAINT fk_item_param_iid FOREIGN KEY (ITEM_ID) REFERENCES item(ID) ON DELETE CASCADE
);

--changeset mdoelle:create_table_consumer_offset
CREATE TABLE consumer_offset (
    topic VARCHAR(511) NOT NULL,
    partition INT NOT NULL,
    consumer_offset BIGINT NOT NULL,

    ctime TIMESTAMP DEFAULT now() NOT NULL,
    mtime TIMESTAMP DEFAULT now() NOT NULL,

    PRIMARY KEY (topic, partition)
);

--changeset bjrke:modify_consumer_offset
ALTER TABLE consumer_offset ADD topic_partition VARCHAR(511);
UPDATE consumer_offset SET topic_partition = topic || '-' || partition;
ALTER TABLE consumer_offset ALTER COLUMN topic_partition SET NOT NULL;
ALTER TABLE consumer_offset DROP PRIMARY KEY;
ALTER TABLE consumer_offset ADD PRIMARY KEY (topic_partition);
ALTER TABLE consumer_offset DROP COLUMN topic;
ALTER TABLE consumer_offset DROP COLUMN partition;

--changeset cewers:add_indexes
CREATE index item_param_item_id_idx ON item_param(item_id);
CREATE index replacement_idx ON role_replacement(replacement);
CREATE index role_idx ON role_replacement(role);
CREATE INDEX role_replacement_profile_idx ON role_replacement(role, replacement, profile_replacement);

