/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.role.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import de.justsoftware.permission.business.config.model.Replacement;
import de.justsoftware.permission.business.role.RoleService;
import de.justsoftware.permission.business.role.model.DirectlyResolvableRole;
import de.justsoftware.permission.business.role.model.ProfileRole;
import de.justsoftware.permission.business.role.model.Role;
import de.justsoftware.permission.persistence.RoleDAO;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RoleServiceImpl
implements RoleService {
    private static final Logger LOG = LoggerFactory.getLogger(RoleServiceImpl.class);
    private final RoleDAO _roleDAO;

    @Autowired
    public RoleServiceImpl(RoleDAO roleDAO) {
        this._roleDAO = roleDAO;
    }

    public void storeRoleReplacements(Table<? extends DirectlyResolvableRole, Role, Boolean> replacements) {
        this._roleDAO.storeRoleReplacements((Table)replacements.cellSet().stream().filter(table -> RoleServiceImpl.isValidReplacememt((DirectlyResolvableRole)((DirectlyResolvableRole)table.getRowKey()), (Role)((Role)table.getColumnKey()), (boolean)((Boolean)table.getValue()))).collect(ImmutableTable.toImmutableTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue)));
    }

    public void replaceRoleReplacements(Map<? extends DirectlyResolvableRole, Replacement> replacements) {
        this._roleDAO.replaceRoleReplacements(Maps.transformEntries(replacements, (directlyResolvableRole, replacement) -> new Replacement((Set)replacement.getAllowed().stream().filter(replacementRole -> RoleServiceImpl.isValidReplacememt((DirectlyResolvableRole)directlyResolvableRole, (Role)replacementRole, (boolean)true)).collect(ImmutableSet.toImmutableSet()))));
    }

    private static boolean isValidReplacememt(DirectlyResolvableRole directlyResolvableRole, Role replacementRole, boolean addEntry) {
        if (!addEntry) {
            return true;
        }
        if (directlyResolvableRole.isItemRoleWithId()) {
            return true;
        }
        if (replacementRole.isUserGroupRole() || replacementRole.isProfileRole()) {
            return true;
        }
        LOG.warn("For searchrole({}) it is not allowed to store invalid role({}) as replacement!", (Object)directlyResolvableRole, (Object)replacementRole);
        return false;
    }

    public ImmutableMap<DirectlyResolvableRole, Replacement> getReplacements(Set<? extends DirectlyResolvableRole> roles) {
        return this._roleDAO.getReplacements(roles);
    }

    public ImmutableMap<DirectlyResolvableRole, Replacement> getNonProfileReplacements(Set<? extends DirectlyResolvableRole> roles) {
        return this._roleDAO.getNonProfileReplacements(roles);
    }

    public ImmutableSetMultimap<Role, DirectlyResolvableRole> getInverseAllowedReplacements(Set<? extends Role> replacements) {
        return this._roleDAO.getInverseAllowedReplacements(replacements);
    }

    public ImmutableSet<DirectlyResolvableRole> filterRolesForProfiles(Set<? extends DirectlyResolvableRole> rolesToResolve, Set<ProfileRole> profileRoles) {
        return this._roleDAO.filterRolesForProfiles(rolesToResolve, profileRoles);
    }
}

