/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.config;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.config.Config;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.TenantId;
import io.micrometer.observation.annotation.Observed;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Observed
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lde/justsoftware/news/domain/config/ConfigService;", "", "<init>", "()V", "getConfig", "Lde/justsoftware/news/domain/config/Config;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "news-service"})
public class ConfigService {
    @NotNull
    public Config getConfig(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getTenantId();
        authContext.checkRead((ItemId)tenantId);
        boolean isSuperAdmin = authContext.isSuperAdmin();
        return new Config(tenantId, authContext.mayCreateChannel(), isSuperAdmin);
    }
}

