/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.comment;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.comment.CommentTextInput;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentDataFetcherKt;
import de.justsoftware.news.domain.comment.PostCommentService;
import de.justsoftware.news.domain.delete.DeleteService;
import de.justsoftware.news.graphql.generated.types.AddCommentInput;
import de.justsoftware.news.graphql.generated.types.Comment;
import de.justsoftware.news.graphql.generated.types.UpdateCommentInput;
import de.justsoftware.news.id.CommentId;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J&\u0010\u0010\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u00112\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001a\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/news/domain/comment/PostCommentMutations;", "", "commentService", "Lde/justsoftware/news/domain/comment/PostCommentService;", "deleteService", "Lde/justsoftware/news/domain/delete/DeleteService;", "<init>", "(Lde/justsoftware/news/domain/comment/PostCommentService;Lde/justsoftware/news/domain/delete/DeleteService;)V", "addComment", "Lde/justsoftware/news/graphql/generated/types/Comment;", "input", "Lde/justsoftware/news/graphql/generated/types/AddCommentInput;", "targetLanguage", "", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "updateComment", "Lde/justsoftware/news/graphql/generated/types/UpdateCommentInput;", "deleteComment", "Lde/justsoftware/news/id/CommentId;", "id", "news-service"})
public class PostCommentMutations {
    @NotNull
    private final PostCommentService commentService;
    @NotNull
    private final DeleteService deleteService;

    public PostCommentMutations(@NotNull PostCommentService commentService, @NotNull DeleteService deleteService) {
        Intrinsics.checkNotNullParameter((Object)commentService, (String)"commentService");
        Intrinsics.checkNotNullParameter((Object)deleteService, (String)"deleteService");
        this.commentService = commentService;
        this.deleteService = deleteService;
    }

    @DgsMutation(field="addComment")
    @NotNull
    public Comment addComment(@InputArgument @NotNull AddCommentInput input, @InputArgument @Nullable String targetLanguage, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        de.justsoftware.news.graphql.generated.types.CommentTextInput commentTextInput = input.getText();
        return PostCommentDataFetcherKt.toGql((PostComment)this.commentService.createComment(input.getReferenceId(), (CommentTextInput)(commentTextInput != null ? PostCommentDataFetcherKt.toDomain((de.justsoftware.news.graphql.generated.types.CommentTextInput)commentTextInput) : null), input.getAttachmentIds(), targetLanguage, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="updateComment")
    @NotNull
    public Comment updateComment(@InputArgument @NotNull UpdateCommentInput input, @InputArgument @Nullable String targetLanguage, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        de.justsoftware.news.graphql.generated.types.CommentTextInput commentTextInput = input.getText();
        return PostCommentDataFetcherKt.toGql((PostComment)this.commentService.update(input.getCommentId(), input.getAttachmentIds(), (CommentTextInput)(commentTextInput != null ? PostCommentDataFetcherKt.toDomain((de.justsoftware.news.graphql.generated.types.CommentTextInput)commentTextInput) : null), targetLanguage, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="deleteComment")
    @NotNull
    public CommentId deleteComment(@InputArgument @NotNull CommentId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.deleteService.markCommentAsDeleted(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }
}

