/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.auth;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import jakarta.servlet.Filter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\n"}, d2={"Lde/justsoftware/news/auth/WebSecurityConfig;", "", "<init>", "()V", "securityFilterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "news-service"})
public class WebSecurityConfig {
    @Bean
    @NotNull
    public SecurityFilterChain securityFilterChain(@NotNull HttpSecurity http, @NotNull JwtVerifier jwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        Object object = http.sessionManagement(WebSecurityConfig::securityFilterChain$lambda$0).exceptionHandling(Customizer.withDefaults()).csrf(WebSecurityConfig::securityFilterChain$lambda$1).anonymous(Customizer.withDefaults()).headers(WebSecurityConfig::securityFilterChain$lambda$2).authorizeHttpRequests(WebSecurityConfig::securityFilterChain$lambda$3).addFilterAfter((Filter)new JwtAuthenticationProcessingFilter(jwtVerifier).applyAllowCookieOnlyVerificationMatcher((RequestMatcher)PathPatternRequestMatcher.withDefaults().matcher("/rest/event/*/ics-export")).applyAllowCookieOnlyVerificationMatcher((RequestMatcher)PathPatternRequestMatcher.withDefaults().matcher("/rest/event/*/csv-export")).applyAllowCookieOnlyVerificationMatcher((RequestMatcher)PathPatternRequestMatcher.withDefaults().matcher("/rest/poll/*/csv-export")), AbstractPreAuthenticatedProcessingFilter.class).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final void securityFilterChain$lambda$0(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void securityFilterChain$lambda$1(CsrfConfigurer it) {
        it.disable();
    }

    private static final void securityFilterChain$lambda$2(HeadersConfigurer it) {
        it.cacheControl(Customizer.withDefaults());
    }

    private static final void securityFilterChain$lambda$3(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        String[] stringArray = new String[]{"/graphiql"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{"/internal/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }
}

