/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.settings.service;

import de.justsoftware.mobile.gateway.settings.model.PlatformInfo;
import de.justsoftware.mobile.gateway.settings.model.PlatformSettings;
import de.justsoftware.mobile.gateway.settings.model.User;
import de.justsoftware.mobile.gateway.toro.model.local.TranslationLanguage;
import de.justsoftware.mobile.gateway.toro.model.remote.ApiMobileAppsInfo;
import de.justsoftware.mobile.gateway.toro.model.remote.ApiMobileAppsSettings;
import de.justsoftware.mobile.gateway.toro.model.remote.ApiMobileAppsUser;
import de.justsoftware.mobile.gateway.toro.service.ToroApiGatewayService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/mobile/gateway/settings/service/SettingsService;", "", "toroApiGatewayService", "Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;", "<init>", "(Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;)V", "getPlatformSettings", "Lde/justsoftware/mobile/gateway/settings/model/PlatformSettings;", "tenantId", "", "getUser", "Lde/justsoftware/mobile/gateway/settings/model/User;", "getPlatformInfo", "Lde/justsoftware/mobile/gateway/settings/model/PlatformInfo;", "updateTranslationLanguage", "profileId", "translationLanguage", "Lde/justsoftware/mobile/gateway/toro/model/local/TranslationLanguage;", "mobileAppsSettings", "Lde/justsoftware/mobile/gateway/toro/model/remote/ApiMobileAppsSettings;", "mobileAppsInfo", "Lde/justsoftware/mobile/gateway/toro/model/remote/ApiMobileAppsInfo;", "mobile-gateway"})
public class SettingsService {
    @NotNull
    private final ToroApiGatewayService toroApiGatewayService;

    public SettingsService(@NotNull ToroApiGatewayService toroApiGatewayService) {
        Intrinsics.checkNotNullParameter((Object)toroApiGatewayService, (String)"toroApiGatewayService");
        this.toroApiGatewayService = toroApiGatewayService;
    }

    @NotNull
    public PlatformSettings getPlatformSettings(@NotNull String tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        ApiMobileAppsSettings apiMobileAppsSettings = this.toroApiGatewayService.getMobileAppsInfo().getSettings();
        return this.getPlatformSettings(tenantId, apiMobileAppsSettings);
    }

    @NotNull
    public User getUser() {
        ApiMobileAppsInfo mobileAppsInfo = this.toroApiGatewayService.getMobileAppsInfo();
        return this.getUser(mobileAppsInfo);
    }

    @NotNull
    public PlatformInfo getPlatformInfo(@NotNull String tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        ApiMobileAppsInfo mobileAppsInfo = this.toroApiGatewayService.getMobileAppsInfo();
        return new PlatformInfo(this.getUser(mobileAppsInfo), this.getPlatformSettings(tenantId, mobileAppsInfo.getSettings()));
    }

    @NotNull
    public User updateTranslationLanguage(@NotNull String profileId, @Nullable TranslationLanguage translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.toroApiGatewayService.updateTranslationLanguage(profileId, translationLanguage);
        return this.getUser();
    }

    private PlatformSettings getPlatformSettings(String tenantId, ApiMobileAppsSettings mobileAppsSettings) {
        boolean bl = mobileAppsSettings.getAbsenceNoteEnabled();
        int n = mobileAppsSettings.getAbsenceNoteMaxLength();
        boolean bl2 = mobileAppsSettings.getAbsenceStatusEnabled();
        boolean bl3 = mobileAppsSettings.getBirthdayListEnabled();
        String string = mobileAppsSettings.getMatomoBaseUrl();
        String string2 = mobileAppsSettings.getMatomoSiteId();
        boolean bl4 = mobileAppsSettings.getChatEnabled();
        boolean bl5 = mobileAppsSettings.getNewsEnabled();
        boolean bl6 = mobileAppsSettings.getDeviceLockRequired();
        boolean bl7 = mobileAppsSettings.getCookieBannerEnabled();
        boolean bl8 = mobileAppsSettings.getChangeEmailEnabled();
        boolean bl9 = mobileAppsSettings.getChangePasswordEnabled();
        boolean bl10 = mobileAppsSettings.getDeleteAccountEnabled();
        boolean bl11 = mobileAppsSettings.getMultiFactorAuthenticationEnabled();
        boolean bl12 = mobileAppsSettings.getBackendTranslationEnabled();
        boolean bl13 = mobileAppsSettings.getNativeNotificationsEnabled();
        String string3 = mobileAppsSettings.getPlatformVersion();
        String string4 = mobileAppsSettings.getTermsPath();
        boolean bl14 = mobileAppsSettings.getMobileEditWikiArticleEnabled();
        return new PlatformSettings(tenantId, bl4, bl5, bl6, bl7, bl8, bl9, bl10, string3, string4, bl, n, bl2, bl3, string, string2, bl11, bl12, bl13, bl14);
    }

    private User getUser(ApiMobileAppsInfo mobileAppsInfo) {
        ApiMobileAppsUser mobileAppsUser = mobileAppsInfo.getUser();
        return new User(mobileAppsUser.getProfileId(), mobileAppsUser.getName(), mobileAppsUser.getFirstName(), mobileAppsUser.getLastName(), mobileAppsUser.getEmail(), mobileAppsUser.getImageId(), mobileAppsUser.getBirthday(), mobileAppsUser.getTermsAcceptanceRequired(), mobileAppsUser.getPreferredTranslationLanguage());
    }
}

