/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.news.controller;

import de.justsoftware.mobile.gateway.authorization.model.AuthorizationContext;
import de.justsoftware.mobile.gateway.news.model.local.AddPostData;
import de.justsoftware.mobile.gateway.news.model.local.Channel;
import de.justsoftware.mobile.gateway.news.model.local.Comment;
import de.justsoftware.mobile.gateway.news.model.local.CommentContent;
import de.justsoftware.mobile.gateway.news.model.local.Feed;
import de.justsoftware.mobile.gateway.news.model.local.NewsConfig;
import de.justsoftware.mobile.gateway.news.model.local.PinPostData;
import de.justsoftware.mobile.gateway.news.model.local.Poll;
import de.justsoftware.mobile.gateway.news.model.local.PollVotes;
import de.justsoftware.mobile.gateway.news.model.local.Post;
import de.justsoftware.mobile.gateway.news.model.local.UpdateEventAttendanceData;
import de.justsoftware.mobile.gateway.news.model.local.UpdatePostData;
import de.justsoftware.mobile.gateway.news.service.NewsService;
import de.justsoftware.mobile.gateway.people.model.local.Profile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/news"})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0017J0\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J6\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H\u0017J\u0012\u0010\u0018\u001a\u00020\u00172\b\b\u0001\u0010\u0019\u001a\u00020\u000eH\u0017J\u0012\u0010\u001a\u001a\u00020\u00172\b\b\u0001\u0010\u0019\u001a\u00020\u000eH\u0017J\u0012\u0010\u001b\u001a\u00020\u00172\b\b\u0001\u0010\u0019\u001a\u00020\u000eH\u0017J\u0012\u0010\u001c\u001a\u00020\u00172\b\b\u0001\u0010\u0019\u001a\u00020\u000eH\u0017J\u0012\u0010\u001d\u001a\u00020\u00172\b\b\u0001\u0010\u0019\u001a\u00020\u000eH\u0017J\u0012\u0010\u001e\u001a\u00020\u00172\b\b\u0001\u0010\u0019\u001a\u00020\u000eH\u0017JJ\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0001\u0010\u0019\u001a\u00020\u000e2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\b\b\u0001\u0010 \u001a\u00020!2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J@\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0001\u0010\u0019\u001a\u00020\u000e2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J6\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00122\b\b\u0001\u0010\u0019\u001a\u00020\u000e2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\b\b\u0001\u0010%\u001a\u00020\u000eH\u0017J\u0012\u0010&\u001a\u00020\u000b2\b\b\u0001\u0010\u0019\u001a\u00020\u000eH\u0017J0\u0010'\u001a\u00020\u00132\b\b\u0001\u0010\u0019\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J&\u0010*\u001a\u00020\u00132\b\b\u0001\u0010+\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J0\u0010,\u001a\u00020\u00132\b\b\u0001\u0010+\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010-\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0012\u0010/\u001a\u00020\u00152\b\b\u0001\u0010+\u001a\u00020\u000eH\u0017J&\u00100\u001a\u00020\u00132\b\b\u0001\u0010+\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J&\u00101\u001a\u00020\u00132\b\b\u0001\u0010+\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J0\u00102\u001a\u00020\u00132\b\b\u0001\u0010+\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u00103\u001a\u0002042\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J0\u00105\u001a\u00020\u00132\b\b\u0001\u0010+\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u00103\u001a\u0002042\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u00106\u001a\b\u0012\u0004\u0012\u00020$0\u00122\b\b\u0001\u0010+\u001a\u00020\u000eH\u0017J$\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00122\b\b\u0001\u0010+\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0017J.\u00109\u001a\b\u0012\u0004\u0012\u0002080\u00122\b\b\u0001\u0010+\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010:\u001a\u00020;H\u0017J(\u0010<\u001a\u0002082\b\b\u0001\u0010+\u001a\u00020\u000e2\b\b\u0001\u0010=\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0017J(\u0010>\u001a\u0002082\b\b\u0001\u0010+\u001a\u00020\u000e2\b\b\u0001\u0010=\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0017J\u0018\u0010?\u001a\b\u0012\u0004\u0012\u00020$0\u00122\b\b\u0001\u0010=\u001a\u00020\u000eH\u0017J8\u0010@\u001a\b\u0012\u0004\u0012\u0002080\u00122\b\b\u0001\u0010+\u001a\u00020\u000e2\b\b\u0001\u0010A\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010:\u001a\u00020;H\u0017J*\u0010B\u001a\u0004\u0018\u0001082\b\b\u0001\u0010=\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010C\u001a\u00020;H\u0017J.\u0010D\u001a\b\u0012\u0004\u0012\u0002080\u00122\b\b\u0001\u0010+\u001a\u00020\u000e2\b\b\u0001\u0010=\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0017J&\u0010E\u001a\u00020\u00132\b\b\u0001\u0010+\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J&\u0010F\u001a\u00020\u00132\b\b\u0001\u0010+\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0012\u0010G\u001a\u00020\u00152\b\b\u0001\u0010+\u001a\u00020\u000eH\u0017J:\u0010H\u001a\u00020I2\b\b\u0001\u0010+\u001a\u00020\u000e2\b\b\u0001\u0010J\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010K\u001a\u00020L2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J6\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J,\u0010N\u001a\b\u0012\u0004\u0012\u00020$0\u00122\b\b\u0001\u0010+\u001a\u00020\u000e2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000bH\u0017J0\u0010O\u001a\u00020\u00132\b\b\u0001\u0010+\u001a\u00020\u000e2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010P\u001a\u00020Q2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lde/justsoftware/mobile/gateway/news/controller/NewsController;", "", "newsService", "Lde/justsoftware/mobile/gateway/news/service/NewsService;", "<init>", "(Lde/justsoftware/mobile/gateway/news/service/NewsService;)V", "getConfig", "Lde/justsoftware/mobile/gateway/news/model/local/NewsConfig;", "getFeed", "Lde/justsoftware/mobile/gateway/news/model/local/Feed;", "offset", "", "limit", "translationLanguage", "", "authContext", "Lde/justsoftware/mobile/gateway/authorization/model/AuthorizationContext;", "getPinnedFeed", "", "Lde/justsoftware/mobile/gateway/news/model/local/Post;", "markFeedAsRead", "", "getChannels", "Lde/justsoftware/mobile/gateway/news/model/local/Channel;", "subscribe", "channelId", "subscribeWithoutNotifications", "unsubscribe", "enableNotifications", "disableNotifications", "getChannel", "getChannelPosts", "pinned", "", "getScheduledChannelPosts", "getChannelSubscribers", "Lde/justsoftware/mobile/gateway/people/model/local/Profile;", "query", "getChannelSubscribersCount", "addPost", "addPostData", "Lde/justsoftware/mobile/gateway/news/model/local/AddPostData;", "getPost", "postId", "updatePost", "updatePostData", "Lde/justsoftware/mobile/gateway/news/model/local/UpdatePostData;", "deletePost", "likePost", "unlikePost", "pinPost", "pinPostData", "Lde/justsoftware/mobile/gateway/news/model/local/PinPostData;", "unpinPost", "getPostLikers", "getComments", "Lde/justsoftware/mobile/gateway/news/model/local/Comment;", "respondToPost", "response", "Lde/justsoftware/mobile/gateway/news/model/local/CommentContent;", "likeComment", "commentId", "unlikeComment", "getCommentLikers", "respondToComment", "referenceId", "updateComment", "updatedContent", "deleteComment", "enableCommentNotifications", "disableCommentNotifications", "markPostAsRead", "voteForPoll", "Lde/justsoftware/mobile/gateway/news/model/local/Poll;", "pollId", "votes", "Lde/justsoftware/mobile/gateway/news/model/local/PollVotes;", "getEvents", "getEventAttendees", "updateEventAttendance", "updateEventAttendanceData", "Lde/justsoftware/mobile/gateway/news/model/local/UpdateEventAttendanceData;", "mobile-gateway"})
public class NewsController {
    @NotNull
    private final NewsService newsService;

    public NewsController(@NotNull NewsService newsService) {
        Intrinsics.checkNotNullParameter((Object)newsService, (String)"newsService");
        this.newsService = newsService;
    }

    @GetMapping(value={"/config"})
    @NotNull
    public NewsConfig getConfig() {
        return this.newsService.getConfig();
    }

    @GetMapping(value={"/feed"})
    @NotNull
    public Feed getFeed(@RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="10") int limit, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.getFeed(offset, limit, authContext.getLocale(), translationLanguage);
    }

    @GetMapping(value={"/feed/pinned"})
    @NotNull
    public List<Post> getPinnedFeed(@RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="10") int limit, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.getPinnedFeed(offset, limit, authContext.getLocale(), translationLanguage);
    }

    @PostMapping(value={"/feed/read"})
    public void markFeedAsRead() {
        this.newsService.markFeedAsRead();
    }

    @GetMapping(value={"/channels"})
    @NotNull
    public List<Channel> getChannels() {
        return this.newsService.getChannels();
    }

    @PostMapping(value={"/channels/{id}/subscribe/notificationsEnabled"})
    @NotNull
    public Channel subscribe(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsService.subscribe(channelId, true);
    }

    @PostMapping(value={"/channels/{id}/subscribe/notificationsDisabled"})
    @NotNull
    public Channel subscribeWithoutNotifications(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsService.subscribe(channelId, false);
    }

    @PostMapping(value={"/channels/{id}/unsubscribe"})
    @NotNull
    public Channel unsubscribe(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsService.unsubscribe(channelId);
    }

    @PostMapping(value={"/channels/{id}/enableNotifications"})
    @NotNull
    public Channel enableNotifications(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsService.subscribe(channelId, true);
    }

    @PostMapping(value={"/channels/{id}/disableNotifications"})
    @NotNull
    public Channel disableNotifications(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsService.subscribe(channelId, false);
    }

    @GetMapping(value={"/channels/{id}"})
    @NotNull
    public Channel getChannel(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsService.getChannel(channelId);
    }

    @GetMapping(value={"/channels/{id}/posts"})
    @NotNull
    public List<Post> getChannelPosts(@PathVariable(value="id") @NotNull String channelId, @RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="10") int limit, @RequestParam(name="pinned", defaultValue="false") boolean pinned, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.getChannelPosts(channelId, offset, limit, false, pinned, authContext.getLocale(), translationLanguage);
    }

    @GetMapping(value={"/channels/{id}/posts/scheduled"})
    @NotNull
    public List<Post> getScheduledChannelPosts(@PathVariable(value="id") @NotNull String channelId, @RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="10") int limit, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.getChannelPosts(channelId, offset, limit, true, false, authContext.getLocale(), translationLanguage);
    }

    @GetMapping(value={"/channels/{id}/subscribers"})
    @NotNull
    public List<Profile> getChannelSubscribers(@PathVariable(value="id") @NotNull String channelId, @RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="100") int limit, @RequestParam(name="query", defaultValue="") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.newsService.getChannelSubscribers(channelId, offset, limit, query);
    }

    @GetMapping(value={"/channels/{id}/subscribersCount"})
    public int getChannelSubscribersCount(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsService.getChannelSubscribersCount(channelId);
    }

    @PostMapping(value={"/channels/{id}/posts"})
    @NotNull
    public Post addPost(@PathVariable(value="id") @NotNull String channelId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @RequestBody @NotNull AddPostData addPostData, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)addPostData, (String)"addPostData");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.addPost(channelId, addPostData, authContext.getLocale(), translationLanguage);
    }

    @GetMapping(value={"/posts/{id}"})
    @NotNull
    public Post getPost(@PathVariable(value="id") @NotNull String postId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.getPost(postId, authContext.getLocale(), translationLanguage);
    }

    @PutMapping(value={"/posts/{id}"})
    @NotNull
    public Post updatePost(@PathVariable(value="id") @NotNull String postId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @RequestBody @NotNull UpdatePostData updatePostData, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)updatePostData, (String)"updatePostData");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.updatePost(postId, updatePostData, authContext.getLocale(), translationLanguage);
    }

    @DeleteMapping(value={"/posts/{id}"})
    public void deletePost(@PathVariable(value="id") @NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        this.newsService.deletePost(postId);
    }

    @PostMapping(value={"/posts/{id}/like"})
    @NotNull
    public Post likePost(@PathVariable(value="id") @NotNull String postId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.likePost(postId, authContext.getLocale(), translationLanguage);
    }

    @PostMapping(value={"/posts/{id}/unlike"})
    @NotNull
    public Post unlikePost(@PathVariable(value="id") @NotNull String postId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.unlikePost(postId, authContext.getLocale(), translationLanguage);
    }

    @PostMapping(value={"/posts/{id}/pin"})
    @NotNull
    public Post pinPost(@PathVariable(value="id") @NotNull String postId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @RequestBody @NotNull PinPostData pinPostData, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)pinPostData, (String)"pinPostData");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.pinPost(postId, authContext.getLocale(), pinPostData, translationLanguage);
    }

    @PostMapping(value={"/posts/{id}/unpin"})
    @NotNull
    public Post unpinPost(@PathVariable(value="id") @NotNull String postId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @RequestBody @NotNull PinPostData pinPostData, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)pinPostData, (String)"pinPostData");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.unpinPost(postId, authContext.getLocale(), pinPostData, translationLanguage);
    }

    @GetMapping(value={"/posts/{id}/likers"})
    @NotNull
    public List<Profile> getPostLikers(@PathVariable(value="id") @NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.newsService.getPostLikers(postId);
    }

    @GetMapping(value={"/posts/{postId}/comments"})
    @NotNull
    public List<Comment> getComments(@PathVariable(value="postId") @NotNull String postId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.newsService.getComments(postId, translationLanguage);
    }

    @PostMapping(value={"/posts/{postId}/comments"})
    @NotNull
    public List<Comment> respondToPost(@PathVariable(value="postId") @NotNull String postId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @RequestBody @NotNull CommentContent response) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return NewsService.addComment$default((NewsService)this.newsService, (String)postId, null, (CommentContent)response, (String)translationLanguage, (int)2, null);
    }

    @PostMapping(value={"/posts/{postId}/comments/{commentId}/like"})
    @NotNull
    public Comment likeComment(@PathVariable(value="postId") @NotNull String postId, @PathVariable(value="commentId") @NotNull String commentId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return this.newsService.likeComment(postId, commentId, translationLanguage);
    }

    @PostMapping(value={"/posts/{postId}/comments/{commentId}/unlike"})
    @NotNull
    public Comment unlikeComment(@PathVariable(value="postId") @NotNull String postId, @PathVariable(value="commentId") @NotNull String commentId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return this.newsService.unlikeComment(postId, commentId, translationLanguage);
    }

    @GetMapping(value={"/posts/{postId}/comments/{commentId}/likers"})
    @NotNull
    public List<Profile> getCommentLikers(@PathVariable(value="commentId") @NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return this.newsService.getCommentLikers(commentId);
    }

    @PostMapping(value={"/posts/{postId}/comments/{referenceId}"})
    @NotNull
    public List<Comment> respondToComment(@PathVariable(value="postId") @NotNull String postId, @PathVariable(value="referenceId") @NotNull String referenceId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @RequestBody @NotNull CommentContent response) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return this.newsService.addComment(postId, referenceId, response, translationLanguage);
    }

    @PutMapping(value={"/posts/{postId}/comments/{commentId}"})
    @Nullable
    public Comment updateComment(@PathVariable(value="commentId") @NotNull String commentId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @RequestBody @NotNull CommentContent updatedContent) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)updatedContent, (String)"updatedContent");
        return this.newsService.updateComment(commentId, updatedContent, translationLanguage);
    }

    @DeleteMapping(value={"/posts/{postId}/comments/{commentId}"})
    @NotNull
    public List<Comment> deleteComment(@PathVariable(value="postId") @NotNull String postId, @PathVariable(value="commentId") @NotNull String commentId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return this.newsService.deleteComment(postId, commentId, translationLanguage);
    }

    @PostMapping(value={"/posts/{postId}/comments/enableNotifications"})
    @NotNull
    public Post enableCommentNotifications(@PathVariable(value="postId") @NotNull String postId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.enableCommentNotifications(postId, true, authContext.getLocale(), translationLanguage);
    }

    @PostMapping(value={"/posts/{postId}/comments/disableNotifications"})
    @NotNull
    public Post disableCommentNotifications(@PathVariable(value="postId") @NotNull String postId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.enableCommentNotifications(postId, false, authContext.getLocale(), translationLanguage);
    }

    @PostMapping(value={"/posts/{postId}/read"})
    public void markPostAsRead(@PathVariable(value="postId") @NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        this.newsService.markPostAsRead(postId);
    }

    @PutMapping(value={"/posts/{postId}/polls/{pollId}/vote"})
    @NotNull
    public Poll voteForPoll(@PathVariable(value="postId") @NotNull String postId, @PathVariable(value="pollId") @NotNull String pollId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @RequestBody @NotNull PollVotes votes, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter((Object)votes, (String)"votes");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.voteForPoll(postId, pollId, votes.getAnswerIds(), authContext.getLocale(), translationLanguage);
    }

    @GetMapping(value={"/events"})
    @NotNull
    public List<Post> getEvents(@RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="10") int limit, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.getEvents(offset, limit, authContext.getLocale(), translationLanguage);
    }

    @GetMapping(value={"/events/{postId}/attendees"})
    @NotNull
    public List<Profile> getEventAttendees(@PathVariable(value="postId") @NotNull String postId, @RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="10") int limit) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.newsService.getEventAttendees(postId, offset, limit);
    }

    @PostMapping(value={"/events/{postId}/attendance"})
    @NotNull
    public Post updateEventAttendance(@PathVariable(value="postId") @NotNull String postId, @RequestParam(value="translationLanguage") @Nullable String translationLanguage, @RequestBody @NotNull UpdateEventAttendanceData updateEventAttendanceData, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)updateEventAttendanceData, (String)"updateEventAttendanceData");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.updateEventAttendance(postId, updateEventAttendanceData, authContext.getLocale(), translationLanguage);
    }
}

