/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.drive.controller;

import de.justsoftware.mobile.gateway.drive.controller.DriveController;
import de.justsoftware.mobile.gateway.drive.controller.DriveController$initBinder$;
import de.justsoftware.mobile.gateway.drive.model.local.AddFolderData;
import de.justsoftware.mobile.gateway.drive.model.local.Document;
import de.justsoftware.mobile.gateway.drive.model.local.DriveId;
import de.justsoftware.mobile.gateway.drive.model.local.FolderDetails;
import de.justsoftware.mobile.gateway.drive.model.local.Share;
import de.justsoftware.mobile.gateway.drive.service.DriveService;
import de.justsoftware.mobile.gateway.util.RestOperationsKt;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.PropertyEditor;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/drive"})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 92\u00020\u0001:\u00019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0010H\u0017J\u0012\u0010\u0012\u001a\u00020\u000e2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J&\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0010H\u0017J\u001c\u0010\u001b\u001a\u00020\u001a2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J\u001c\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010 \u001a\u00020\u001a2\b\b\u0001\u0010!\u001a\u00020\"H\u0017J\u0012\u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020\u001aH\u0017J\u0012\u0010&\u001a\u00020\t2\b\b\u0001\u0010%\u001a\u00020\u001aH\u0017J\"\u0010'\u001a\u00020\t2\b\b\u0001\u0010%\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0017J\"\u0010,\u001a\u00020\t2\b\b\u0001\u0010%\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0017J\u0018\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\b\b\u0001\u0010%\u001a\u00020\u001fH\u0017J\u0012\u00100\u001a\u00020\u001f2\b\b\u0001\u0010%\u001a\u00020\u001fH\u0017J\u001c\u00101\u001a\u00020\u001a2\b\b\u0001\u0010%\u001a\u00020\u001a2\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J\u0012\u00102\u001a\u0002032\b\b\u0001\u0010%\u001a\u00020\u001aH\u0017J\u0012\u00104\u001a\u0002052\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J \u00106\u001a\u00020\t2\u0006\u00107\u001a\u0002082\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lde/justsoftware/mobile/gateway/drive/controller/DriveController;", "", "driveService", "Lde/justsoftware/mobile/gateway/drive/service/DriveService;", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Lde/justsoftware/mobile/gateway/drive/service/DriveService;Lorg/springframework/web/reactive/function/client/WebClient;)V", "initBinder", "", "binder", "Lorg/springframework/web/bind/WebDataBinder;", "getShares", "", "Lde/justsoftware/mobile/gateway/drive/model/local/Share;", "offset", "", "limit", "getShare", "shareId", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$Share;", "subscribeToShare", "unsubscribeFromShare", "getFolderDetails", "Lde/justsoftware/mobile/gateway/drive/model/local/FolderDetails;", "folderId", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$DriveDocument;", "uploadToFolder", "file", "Lorg/springframework/web/multipart/MultipartFile;", "addFolder", "", "parentFolderId", "addFolderData", "Lde/justsoftware/mobile/gateway/drive/model/local/AddFolderData;", "getDocument", "Lde/justsoftware/mobile/gateway/drive/model/local/Document;", "documentId", "deleteDocument", "downloadAttachment", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "downloadAttachmentPreview", "downloadAttachmentVideoStream", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/core/io/Resource;", "getUnauthorizedAttachmentVideoUrl", "setVideoTeaser", "removeVideoTeaser", "", "uploadTemporaryFile", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$TempFile;", "download", "uri", "Ljava/net/URI;", "Companion", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nDriveController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriveController.kt\nde/justsoftware/mobile/gateway/drive/controller/DriveController\n+ 2 RestControllers.kt\nde/justsoftware/mobile/gateway/util/RestControllersKt\n*L\n1#1,209:1\n9#2,10:210\n9#2,10:220\n9#2,10:230\n*S KotlinDebug\n*F\n+ 1 DriveController.kt\nde/justsoftware/mobile/gateway/drive/controller/DriveController\n*L\n41#1:210,10\n45#1:220,10\n49#1:230,10\n*E\n"})
public class DriveController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DriveService driveService;
    @NotNull
    private final WebClient webClient;

    public DriveController(@NotNull DriveService driveService, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)driveService, (String)"driveService");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.driveService = driveService;
        this.webClient = webClient;
    }

    @InitBinder
    public void initBinder(@NotNull WebDataBinder binder) {
        WebDataBinder webDataBinder;
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        WebDataBinder $this$registerEditor$iv = binder;
        boolean $i$f$registerEditor = false;
        WebDataBinder $this$registerEditor_u24lambda_u240$iv = webDataBinder = $this$registerEditor$iv;
        boolean bl = false;
        initBinder$$inlined$registerEditor$1 editor$iv = new /* Unavailable Anonymous Inner Class!! */;
        $this$registerEditor_u24lambda_u240$iv.registerCustomEditor(DriveId.Share.class, (PropertyEditor)editor$iv);
        $this$registerEditor$iv = webDataBinder;
        $i$f$registerEditor = false;
        $this$registerEditor_u24lambda_u240$iv = webDataBinder = $this$registerEditor$iv;
        bl = false;
        editor$iv = new /* Unavailable Anonymous Inner Class!! */;
        $this$registerEditor_u24lambda_u240$iv.registerCustomEditor(DriveId.DriveDocument.class, (PropertyEditor)editor$iv);
        $this$registerEditor$iv = webDataBinder;
        $i$f$registerEditor = false;
        $this$registerEditor_u24lambda_u240$iv = webDataBinder = $this$registerEditor$iv;
        bl = false;
        editor$iv = new /* Unavailable Anonymous Inner Class!! */;
        $this$registerEditor_u24lambda_u240$iv.registerCustomEditor(DriveId.TempFile.class, (PropertyEditor)editor$iv);
    }

    @GetMapping(value={"/shares"})
    @NotNull
    public List<Share> getShares(@RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="20") int limit) {
        return this.driveService.getShares(offset, limit);
    }

    @GetMapping(value={"/shares/{shareId}"})
    @NotNull
    public Share getShare(@PathVariable(value="shareId") @NotNull DriveId.Share shareId) {
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        return this.driveService.getShare(shareId);
    }

    @PostMapping(value={"/shares/{shareId}/subscribe"})
    @Nullable
    public Share subscribeToShare(@PathVariable(value="shareId") @NotNull DriveId.Share shareId) {
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        return this.driveService.subscribeToShare(shareId);
    }

    @PostMapping(value={"/shares/{shareId}/unsubscribe"})
    @Nullable
    public Share unsubscribeFromShare(@PathVariable(value="shareId") @NotNull DriveId.Share shareId) {
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        return this.driveService.unsubscribeFromShare(shareId);
    }

    @GetMapping(value={"/folders/{folderId}"})
    @NotNull
    public FolderDetails getFolderDetails(@PathVariable(value="folderId") @NotNull DriveId.DriveDocument folderId, @RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="100") int limit) {
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        return this.driveService.getFolderDetails(folderId, offset, limit);
    }

    @PostMapping(value={"/folders/{folderId}/upload"})
    @NotNull
    public DriveId.DriveDocument uploadToFolder(@PathVariable(value="folderId") @NotNull DriveId.DriveDocument folderId, @RequestParam(value="file") @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.driveService.uploadToFolder(folderId, file);
    }

    @PostMapping(value={"/folders/{parentFolderId}"})
    @NotNull
    public String addFolder(@PathVariable(value="parentFolderId") @NotNull DriveId.DriveDocument parentFolderId, @RequestBody @NotNull AddFolderData addFolderData) {
        Intrinsics.checkNotNullParameter((Object)parentFolderId, (String)"parentFolderId");
        Intrinsics.checkNotNullParameter((Object)addFolderData, (String)"addFolderData");
        return this.driveService.addFolder(parentFolderId, addFolderData);
    }

    @GetMapping(value={"/documents/{documentId}"})
    @NotNull
    public Document getDocument(@PathVariable(value="documentId") @NotNull DriveId.DriveDocument documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.driveService.getDocument(documentId);
    }

    @DeleteMapping(value={"/documents/{documentId}"})
    public void deleteDocument(@PathVariable(value="documentId") @NotNull DriveId.DriveDocument documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        this.driveService.deleteDocument(documentId);
    }

    @GetMapping(value={"/attachment/{documentId}"})
    public void downloadAttachment(@PathVariable(value="documentId") @NotNull String documentId, @NotNull HttpServletRequest request2, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.download(this.driveService.getDownloadAttachmentUri(documentId), request2, response);
    }

    @GetMapping(value={"/attachment/{documentId}/preview"})
    public void downloadAttachmentPreview(@PathVariable(value="documentId") @NotNull String documentId, @NotNull HttpServletRequest request2, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.download(this.driveService.getDownloadAttachmentPreviewUri(documentId), request2, response);
    }

    @GetMapping(value={"/attachment/{documentId}/video"})
    @NotNull
    public ResponseEntity<Resource> downloadAttachmentVideoStream(@PathVariable(value="documentId") @NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return RestOperationsKt.redirectOnSameHostTo((String)this.driveService.getDownloadAttachmentVideoStreamUrl(documentId));
    }

    @GetMapping(value={"/attachment/{documentId}/video/url"})
    @NotNull
    public String getUnauthorizedAttachmentVideoUrl(@PathVariable(value="documentId") @NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.driveService.getUnauthorizedAttachmentVideoUrl(documentId);
    }

    @PostMapping(value={"/attachment/{documentId}/video/teaser"})
    @NotNull
    public DriveId.DriveDocument setVideoTeaser(@PathVariable(value="documentId") @NotNull DriveId.DriveDocument documentId, @RequestParam(value="file") @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.driveService.setVideoTeaser(documentId, file);
    }

    @DeleteMapping(value={"/attachment/{documentId}/video/teaser"})
    public boolean removeVideoTeaser(@PathVariable(value="documentId") @NotNull DriveId.DriveDocument documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.driveService.removeVideoTeaser(documentId);
    }

    @PostMapping(value={"/tmp/upload"}, produces={"application/json"})
    @NotNull
    public DriveId.TempFile uploadTemporaryFile(@RequestParam(value="file") @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.driveService.uploadTemporaryFile(file);
    }

    private void download(URI uri, HttpServletRequest request2, HttpServletResponse response) {
        WebClient.RequestHeadersSpec requestHeadersSpec = this.webClient.get().uri(uri);
        Intrinsics.checkNotNullExpressionValue((Object)requestHeadersSpec, (String)"uri(...)");
        Companion.access$copyHeadersAndDownload((Companion)Companion, (WebClient.RequestHeadersSpec)requestHeadersSpec, (HttpServletRequest)request2, (HttpServletResponse)response);
    }
}

