/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.common.model;

import de.justsoftware.mobile.gateway.common.model.MobileAppVersion;
import de.justsoftware.mobile.gateway.exception.InvalidClientVersionException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/mobile/gateway/common/model/MobileAppVersion;", "", "client", "Lde/justsoftware/mobile/gateway/common/model/MobileAppVersion$Client;", "versionCode", "", "<init>", "(Lde/justsoftware/mobile/gateway/common/model/MobileAppVersion$Client;J)V", "getClient", "()Lde/justsoftware/mobile/gateway/common/model/MobileAppVersion$Client;", "getVersionCode", "()J", "validate", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Client", "Companion", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nMobileAppVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobileAppVersion.kt\nde/justsoftware/mobile/gateway/common/model/MobileAppVersion\n+ 2 InvalidClientVersionException.kt\nde/justsoftware/mobile/gateway/exception/InvalidClientVersionException$Companion\n+ 3 LoggerUtils.kt\nde/justsoftware/mobile/gateway/util/LoggerUtilsKt\n*L\n1#1,85:1\n9#2,2:86\n9#3:88\n8#3,3:89\n*S KotlinDebug\n*F\n+ 1 MobileAppVersion.kt\nde/justsoftware/mobile/gateway/common/model/MobileAppVersion\n*L\n16#1:86,2\n22#1:88\n22#1:89,3\n*E\n"})
public final class MobileAppVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    private final long versionCode;
    @NotNull
    private static final MobileAppVersion UNKNOWN_CLIENT_VERSION = new MobileAppVersion(Client.UNKNOWN, 0L);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Regex ANDROID_SOCIAL_VERSION_CODE_REGEX;
    @NotNull
    private static final Regex IOS_SOCIAL_VERSION_CODE_REGEX;
    @NotNull
    private static final Regex IOS_SOCIAL_APP_VERSION_REGEX;

    public MobileAppVersion(@NotNull Client client, long versionCode) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.versionCode = versionCode;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    public final long getVersionCode() {
        return this.versionCode;
    }

    public final void validate() {
        InvalidClientVersionException.Companion companion = InvalidClientVersionException.Companion;
        boolean value$iv = this.versionCode >= this.client.getMinVersion();
        boolean $i$f$validate = false;
        if (!value$iv) {
            boolean bl = false;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            String string = null;
            String string2 = "The app version code is too low. Found version " + this.versionCode + ", min version for " + this.client + " is " + this.client.getMinVersion();
            throw new InvalidClientVersionException(string2, string, n, defaultConstructorMarker);
        }
    }

    @NotNull
    public final Client component1() {
        return this.client;
    }

    public final long component2() {
        return this.versionCode;
    }

    @NotNull
    public final MobileAppVersion copy(@NotNull Client client, long versionCode) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return new MobileAppVersion(client, versionCode);
    }

    public static /* synthetic */ MobileAppVersion copy$default(MobileAppVersion mobileAppVersion, Client client, long l, int n, Object object) {
        if ((n & 1) != 0) {
            client = mobileAppVersion.client;
        }
        if ((n & 2) != 0) {
            l = mobileAppVersion.versionCode;
        }
        return mobileAppVersion.copy(client, l);
    }

    @NotNull
    public String toString() {
        return "MobileAppVersion(client=" + this.client + ", versionCode=" + this.versionCode + ")";
    }

    public int hashCode() {
        int result = this.client.hashCode();
        result = result * 31 + Long.hashCode(this.versionCode);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MobileAppVersion)) {
            return false;
        }
        MobileAppVersion mobileAppVersion = (MobileAppVersion)other;
        if (this.client != mobileAppVersion.client) {
            return false;
        }
        return this.versionCode == mobileAppVersion.versionCode;
    }

    public static final /* synthetic */ MobileAppVersion access$getUNKNOWN_CLIENT_VERSION$cp() {
        return UNKNOWN_CLIENT_VERSION;
    }

    public static final /* synthetic */ Regex access$getANDROID_SOCIAL_VERSION_CODE_REGEX$cp() {
        return ANDROID_SOCIAL_VERSION_CODE_REGEX;
    }

    public static final /* synthetic */ Regex access$getIOS_SOCIAL_VERSION_CODE_REGEX$cp() {
        return IOS_SOCIAL_VERSION_CODE_REGEX;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Regex access$getIOS_SOCIAL_APP_VERSION_REGEX$cp() {
        return IOS_SOCIAL_APP_VERSION_REGEX;
    }

    static {
        Companion $this$logger$iv = Companion;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        ANDROID_SOCIAL_VERSION_CODE_REGEX = new Regex("\\bJustSocial/(\\d+)\\b.*\\(Android/.*");
        IOS_SOCIAL_VERSION_CODE_REGEX = new Regex("\\bJustSocial/(\\d+\\.\\d+(?:\\.\\d+)?) Build/\\d+ iOS/");
        IOS_SOCIAL_APP_VERSION_REGEX = new Regex("(\\d+)\\.(\\d+)(?:\\.(\\d+))?");
    }
}

