/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.common.configuration;

import de.justsoftware.mobile.gateway.common.configuration.MobileGatewayConfiguration;
import de.justsoftware.mobile.gateway.common.configuration.WebClientConfiguration;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.web.context.annotation.RequestScope;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.SslProvider;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/mobile/gateway/common/configuration/WebClientConfiguration;", "", "sslBundles", "Lorg/springframework/boot/ssl/SslBundles;", "<init>", "(Lorg/springframework/boot/ssl/SslBundles;)V", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "builder", "Lorg/springframework/web/reactive/function/client/WebClient$Builder;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "secureWebClient", "codecCustomizer", "Lorg/springframework/boot/web/codec/CodecCustomizer;", "maxInMemorySize", "", "commonRequestFilter", "Lorg/springframework/web/reactive/function/client/ExchangeFilterFunction;", "originalRequest", "Companion", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nWebClientConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebClientConfiguration.kt\nde/justsoftware/mobile/gateway/common/configuration/WebClientConfiguration\n+ 2 WebClientConfiguration.kt\nde/justsoftware/mobile/gateway/common/configuration/WebClientConfiguration$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n89#2:99\n1915#3,2:100\n*S KotlinDebug\n*F\n+ 1 WebClientConfiguration.kt\nde/justsoftware/mobile/gateway/common/configuration/WebClientConfiguration\n*L\n77#1:99\n78#1:100,2\n*E\n"})
public class WebClientConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SslBundles sslBundles;

    public WebClientConfiguration(@NotNull SslBundles sslBundles) {
        Intrinsics.checkNotNullParameter((Object)sslBundles, (String)"sslBundles");
        this.sslBundles = sslBundles;
    }

    @Bean
    @RequestScope
    @NotNull
    public WebClient webClient(@NotNull WebClient.Builder builder, @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        WebClient webClient = builder.filter(this.commonRequestFilter(request2)).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        return webClient;
    }

    @Bean
    @RequestScope
    @Qualifier(value="secureWebClient")
    @NotNull
    public WebClient secureWebClient(@NotNull WebClient.Builder builder, @NotNull HttpServletRequest request2) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        SslBundle sslBundle = this.sslBundles.getBundle("just");
        SslContext sslContext = SslContextBuilder.forClient().keyManager(sslBundle.getManagers().getKeyManagerFactory()).trustManager(sslBundle.getManagers().getTrustManagerFactory()).build();
        HttpClient httpClient = HttpClient.create().secure(arg_0 -> WebClientConfiguration.secureWebClient$lambda$1(arg_0 -> WebClientConfiguration.secureWebClient$lambda$0(sslContext, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"secure(...)");
        HttpClient httpClient2 = httpClient;
        WebClient webClient = builder.filter(this.commonRequestFilter(request2)).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient2)).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        return webClient;
    }

    @Bean
    @NotNull
    public CodecCustomizer codecCustomizer(@Value(value="${spring.codec.max-in-memory-size}") int maxInMemorySize) {
        return arg_0 -> WebClientConfiguration.codecCustomizer$lambda$0(maxInMemorySize, arg_0);
    }

    private ExchangeFilterFunction commonRequestFilter(HttpServletRequest originalRequest) {
        return (arg_0, arg_1) -> WebClientConfiguration.commonRequestFilter$lambda$0(originalRequest, arg_0, arg_1);
    }

    private static final Unit secureWebClient$lambda$0(SslContext $sslContext, SslProvider.SslContextSpec it) {
        it.sslContext($sslContext);
        return Unit.INSTANCE;
    }

    private static final void secureWebClient$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void codecCustomizer$lambda$0(int $maxInMemorySize, CodecConfigurer configurer) {
        CodecConfigurer.DefaultCodecs defaultCodecs;
        CodecConfigurer.DefaultCodecs $this$codecCustomizer_u24lambda_u240_u240 = defaultCodecs = configurer.defaultCodecs();
        boolean bl = false;
        $this$codecCustomizer_u24lambda_u240_u240.maxInMemorySize($maxInMemorySize);
    }

    private static final Mono commonRequestFilter$lambda$0(HttpServletRequest $originalRequest, ClientRequest request2, ExchangeFunction next) {
        ClientRequest.Builder builder;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        Companion companion = Companion;
        ClientRequest $this$buildUpon$iv = request2;
        boolean $i$f$buildUpon = false;
        ClientRequest.Builder builder2 = ClientRequest.from((ClientRequest)$this$buildUpon$iv);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"from(...)");
        ClientRequest.Builder $this$commonRequestFilter_u24lambda_u240_u240 = builder = builder2;
        boolean bl = false;
        Iterable $this$forEach$iv = MobileGatewayConfiguration.INSTANCE.getAPI_GATEWAY_HEADERS();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String header = (String)element$iv;
            boolean bl2 = false;
            Companion.access$addHeader((Companion)Companion, (ClientRequest.Builder)$this$commonRequestFilter_u24lambda_u240_u240, (String)header, (HttpServletRequest)$originalRequest);
        }
        ClientRequest clientRequest = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)clientRequest, (String)"build(...)");
        ClientRequest updatedRequest = clientRequest;
        return next.exchange(updatedRequest);
    }
}

