/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.common.configuration;

import de.justsoftware.mobile.gateway.people.generated.apis.ProfileControllerApi;
import de.justsoftware.mobile.gateway.people.generated.apis.UserGroupControllerApi;
import de.justsoftware.mobile.gateway.wiki.generated.apis.WikiControllerApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.client.RestClientSsl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInitializer;
import org.springframework.web.client.RestClient;

@Configuration
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B3\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0012R\u0010\u0010\u0002\u001a\u00020\u00038\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/mobile/gateway/common/configuration/OpenApiConfiguration;", "", "wikiBaseUrl", "", "peopleBaseUrl", "requestInitializer", "Lorg/springframework/http/client/ClientHttpRequestInitializer;", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "ssl", "Lorg/springframework/boot/autoconfigure/web/client/RestClientSsl;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/springframework/http/client/ClientHttpRequestInitializer;Lorg/springframework/web/client/RestClient$Builder;Lorg/springframework/boot/autoconfigure/web/client/RestClientSsl;)V", "wikiControllerApi", "Lde/justsoftware/mobile/gateway/wiki/generated/apis/WikiControllerApi;", "profileControllerApi", "Lde/justsoftware/mobile/gateway/people/generated/apis/ProfileControllerApi;", "userGroupControllerApi", "Lde/justsoftware/mobile/gateway/people/generated/apis/UserGroupControllerApi;", "restClient", "Lorg/springframework/web/client/RestClient;", "baseUrl", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nOpenApiConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenApiConfiguration.kt\nde/justsoftware/mobile/gateway/common/configuration/OpenApiConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public class OpenApiConfiguration {
    @Value(value="${just.wiki.baseUrl}")
    @NotNull
    private final String wikiBaseUrl;
    @Value(value="${just.people.baseUrl}")
    @NotNull
    private final String peopleBaseUrl;
    @NotNull
    private final ClientHttpRequestInitializer requestInitializer;
    @NotNull
    private final RestClient.Builder restClientBuilder;
    @NotNull
    private final RestClientSsl ssl;

    public OpenApiConfiguration(@Value(value="${just.wiki.baseUrl}") @NotNull String wikiBaseUrl, @Value(value="${just.people.baseUrl}") @NotNull String peopleBaseUrl, @NotNull ClientHttpRequestInitializer requestInitializer, @NotNull RestClient.Builder restClientBuilder, @NotNull RestClientSsl ssl) {
        Intrinsics.checkNotNullParameter((Object)wikiBaseUrl, (String)"wikiBaseUrl");
        Intrinsics.checkNotNullParameter((Object)peopleBaseUrl, (String)"peopleBaseUrl");
        Intrinsics.checkNotNullParameter((Object)requestInitializer, (String)"requestInitializer");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        this.wikiBaseUrl = wikiBaseUrl;
        this.peopleBaseUrl = peopleBaseUrl;
        this.requestInitializer = requestInitializer;
        this.restClientBuilder = restClientBuilder;
        this.ssl = ssl;
    }

    @Bean
    @NotNull
    public WikiControllerApi wikiControllerApi() {
        RestClient p0 = this.restClient(this.wikiBaseUrl);
        boolean bl = false;
        return new WikiControllerApi(p0);
    }

    @Bean
    @NotNull
    public ProfileControllerApi profileControllerApi() {
        RestClient p0 = this.restClient(this.peopleBaseUrl);
        boolean bl = false;
        return new ProfileControllerApi(p0);
    }

    @Bean
    @NotNull
    public UserGroupControllerApi userGroupControllerApi() {
        RestClient p0 = this.restClient(this.peopleBaseUrl);
        boolean bl = false;
        return new UserGroupControllerApi(p0);
    }

    private RestClient restClient(String baseUrl) {
        RestClient restClient = this.restClientBuilder.requestInitializer(this.requestInitializer).apply(this.ssl.fromBundle("just")).baseUrl(baseUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        return restClient;
    }
}

