/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.types.Meta;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.ScimResourceTrimmer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourcePreparer<T extends ScimResource> {
    private final ResourceTypeDefinition _resourceType;
    private final URI _baseUri;
    private final Set<Path> _queryAttributes;
    private final boolean _excluded;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="logic should be refactored and the no exception thrown in constructor")
    public ResourcePreparer(ResourceTypeDefinition resourceType, @Nullable Set<String> attributes, @Nullable Set<String> excludedAttributes, URI baseUri) throws BadRequestException {
        if (attributes != null && !attributes.isEmpty()) {
            this._queryAttributes = new LinkedHashSet(attributes.size());
            for (String attribute : attributes) {
                Path normalizedPath;
                try {
                    normalizedPath = resourceType.normalizePath(Path.fromString((String)attribute)).withoutFilters();
                }
                catch (BadRequestException e) {
                    throw BadRequestException.invalidValue((String)("'" + attribute + "' is not a valid value for the attributes parameter: " + e.getMessage()));
                }
                this._queryAttributes.add(normalizedPath);
            }
            this._excluded = false;
        } else if (excludedAttributes != null && !excludedAttributes.isEmpty()) {
            this._queryAttributes = new LinkedHashSet(excludedAttributes.size());
            for (String attribute : excludedAttributes) {
                Path normalizedPath;
                try {
                    normalizedPath = resourceType.normalizePath(Path.fromString((String)attribute)).withoutFilters();
                }
                catch (BadRequestException e) {
                    throw BadRequestException.invalidValue((String)("'" + attribute + "' is not a valid value for the excludedAttributes parameter: " + e.getMessage()));
                }
                this._queryAttributes.add(normalizedPath);
            }
            this._excluded = true;
        } else {
            this._queryAttributes = Collections.emptySet();
            this._excluded = true;
        }
        this._resourceType = resourceType;
        this._baseUri = baseUri;
    }

    public GenericScimResource trimRetrievedResource(T returnedResource) {
        return this.trimReturned(returnedResource, null, null);
    }

    public GenericScimResource trimCreatedResource(T returnedResource, T requestResource) {
        return this.trimReturned(returnedResource, requestResource, null);
    }

    public GenericScimResource trimReplacedResource(T returnedResource, T requestResource) {
        return this.trimReturned(returnedResource, requestResource, null);
    }

    public GenericScimResource trimModifiedResource(T returnedResource, Iterable<PatchOperation> patchOperations) {
        return this.trimReturned(returnedResource, null, patchOperations);
    }

    public void setResourceTypeAndLocation(T returnedResource) {
        Meta meta = returnedResource.getMeta();
        boolean metaUpdated = false;
        if (meta == null) {
            meta = new Meta();
        }
        if (meta.getResourceType() == null) {
            meta.setResourceType(this._resourceType.getName());
            metaUpdated = true;
        }
        if (meta.getLocation() == null) {
            String id = returnedResource.getId();
            if (id != null) {
                UriComponentsBuilder locationBuilder = UriComponentsBuilder.fromUri((URI)this._baseUri).pathSegment(new String[]{ResourcePreparer.encodeTemplateNames((String)id)});
                meta.setLocation(locationBuilder.build(new Object[0]));
            } else {
                meta.setLocation(this._baseUri);
            }
            metaUpdated = true;
        }
        if (metaUpdated) {
            returnedResource.setMeta(meta);
        }
    }

    private GenericScimResource trimReturned(T returnedResource, @Nullable T requestResource, @Nullable Iterable<PatchOperation> patchOperations) {
        Set requestAttributes = Collections.emptySet();
        if (requestResource != null) {
            ObjectNode requestObject = requestResource.asGenericScimResource().getObjectNode();
            requestAttributes = new LinkedHashSet();
            this.collectAttributes(Path.root(), requestAttributes, requestObject);
        }
        if (patchOperations != null) {
            requestAttributes = new LinkedHashSet();
            this.collectAttributes(requestAttributes, patchOperations);
        }
        this.setResourceTypeAndLocation(returnedResource);
        GenericScimResource genericReturnedResource = returnedResource.asGenericScimResource();
        ScimResourceTrimmer trimmer = new ScimResourceTrimmer(this._resourceType, requestAttributes, this._queryAttributes, this._excluded);
        return new GenericScimResource(trimmer.trimObjectNode(genericReturnedResource.getObjectNode()));
    }

    private void collectAttributes(Path parentPath, Set<Path> paths, ObjectNode objectNode) {
        Iterator i = objectNode.fields();
        while (i.hasNext()) {
            Map.Entry field = (Map.Entry)i.next();
            Path path = parentPath.attribute((String)field.getKey());
            if (path.size() > 1 || path.getSchemaUrn() == null) {
                paths.add(path);
            }
            if (((JsonNode)field.getValue()).isArray()) {
                this.collectAttributes(path, paths, (ArrayNode)field.getValue());
                continue;
            }
            if (!((JsonNode)field.getValue()).isObject()) continue;
            this.collectAttributes(path, paths, (ObjectNode)field.getValue());
        }
    }

    private void collectAttributes(Path parentPath, Set<Path> paths, ArrayNode arrayNode) {
        for (JsonNode value : arrayNode) {
            if (value.isArray()) {
                this.collectAttributes(parentPath, paths, (ArrayNode)value);
                continue;
            }
            if (!value.isObject()) continue;
            this.collectAttributes(parentPath, paths, (ObjectNode)value);
        }
    }

    private void collectAttributes(Set<Path> paths, Iterable<PatchOperation> patchOperations) {
        for (PatchOperation patchOperation : patchOperations) {
            Path path = Path.root();
            if (patchOperation.getPath() != null) {
                path = this._resourceType.normalizePath(patchOperation.getPath()).withoutFilters();
                paths.add(path);
            }
            if (patchOperation.getJsonNode() == null) continue;
            if (patchOperation.getJsonNode().isArray()) {
                this.collectAttributes(path, paths, (ArrayNode)patchOperation.getJsonNode());
                continue;
            }
            if (!patchOperation.getJsonNode().isObject()) continue;
            this.collectAttributes(path, paths, (ObjectNode)patchOperation.getJsonNode());
        }
    }

    public static String encodeTemplateNames(String s) {
        String s1 = s;
        int i = s1.indexOf(123);
        if (i != -1) {
            s1 = s1.replace("{", "%7B");
        }
        if ((i = s1.indexOf(125)) != -1) {
            s1 = s1.replace("}", "%7D");
        }
        return s1;
    }
}

