/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.justimport.persistence.model.DbAuditModel;
import de.justsoftware.justimport.persistence.model.DbUserGroupMemberId;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="UserGroupMember")
@EntityListeners(value={AuditingEntityListener.class})
public class DbUserGroupMember
extends DbAuditModel {
    @EmbeddedId
    private DbUserGroupMemberId id;
    @Column
    private @Nullable Instant importedAt;
    @Column
    private @Nullable ImportMethod importMethod;

    public DbUserGroupMember() {
    }

    public DbUserGroupMember(DbUserGroupMemberId id, @Nullable Instant importedAt, @Nullable ImportMethod importMethod) {
        this.id = id;
        this.importedAt = importedAt;
        this.importMethod = importMethod;
    }

    public DbUserGroupMemberId getId() {
        return this.id;
    }

    public UUID getProfileId() {
        return this.getId().getProfileId();
    }

    public UUID getUserGroupId() {
        return this.getId().getUserGroupId();
    }

    public @Nullable Instant getImportedAt() {
        return this.importedAt;
    }

    public @Nullable ImportMethod getImportMethod() {
        return this.importMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbUserGroupMember that = (DbUserGroupMember)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.importedAt, that.importedAt) && Objects.equals(this.importMethod, that.importMethod);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.importedAt, this.importMethod);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id).add("importedAt", (Object)this.importedAt).add("importMethod", (Object)this.importMethod).toString();
    }
}

