/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupId;
import de.justsoftware.justimport.kafka.model.KafkaUserGroup;
import de.justsoftware.justimport.persistence.model.DbAuditModel;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.jspecify.annotations.Nullable;

@Entity
@Table(name="UserGroup")
public class DbUserGroup
extends DbAuditModel {
    @Id
    private UUID id;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false)
    private UUID tenantId;
    @Column(nullable=false)
    private boolean isAllTenantUsersGroup;
    @Column
    private @Nullable Instant importedAt;
    @Column
    private @Nullable ImportMethod importMethod;

    public DbUserGroup() {
    }

    public DbUserGroup(UUID id, String name, UUID tenantId, boolean isAllTenantUsersGroup, @Nullable Instant importedAt, @Nullable ImportMethod importMethod) {
        this.id = id;
        this.name = name;
        this.tenantId = tenantId;
        this.isAllTenantUsersGroup = isAllTenantUsersGroup;
        this.importedAt = importedAt;
        this.importMethod = importMethod;
    }

    public static DbUserGroup fromKafka(KafkaUserGroup group) {
        return new DbUserGroup((UUID)group.id().getId(), group.name(), (UUID)group.tenantId().getId(), group.isAllTenantUsersGroup(), null, null);
    }

    public UUID getId() {
        return this.id;
    }

    public UserGroupId getGroupId() {
        return new UserGroupId(this.id);
    }

    public String getName() {
        return this.name;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public boolean isAllTenantUsersGroup() {
        return this.isAllTenantUsersGroup;
    }

    public @Nullable Instant getImportedAt() {
        return this.importedAt;
    }

    public @Nullable ImportMethod getImportMethod() {
        return this.importMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbUserGroup that = (DbUserGroup)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.isAllTenantUsersGroup, that.isAllTenantUsersGroup) && Objects.equals(this.importedAt, that.importedAt) && Objects.equals(this.importMethod, that.importMethod);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.tenantId, this.isAllTenantUsersGroup, this.importedAt, this.importMethod);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id).add("name", (Object)this.name).add("tenantId", (Object)this.tenantId).add("isAllTenantUsersGroup", this.isAllTenantUsersGroup).add("importedAt", (Object)this.importedAt).add("importMethod", (Object)this.importMethod).toString();
    }
}

