/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence.model;

import com.unboundid.scim2.common.exceptions.PreconditionFailedException;
import com.unboundid.scim2.common.types.UserResource;
import de.justsoftware.justimport.business.model.ValidUserResource;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.persistence.model.DbAuditModel;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.UUID;
import org.hibernate.annotations.JdbcTypeCode;
import org.jspecify.annotations.Nullable;

@Entity
@Table(name="ScimUserResource")
public class DbScimUserResource
extends DbAuditModel {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private @Nullable UUID id;
    @Column(nullable=false)
    private UUID tenantId;
    @Column(nullable=false)
    private UUID profileId;
    @JdbcTypeCode(value=3001)
    @Column(nullable=false)
    private UserResource data;

    public DbScimUserResource() {
    }

    public DbScimUserResource(UUID profileId, TenantId tenantId, ValidUserResource user) {
        this.tenantId = (UUID)tenantId.getId();
        this.profileId = profileId;
        this.data = user.asUserResource();
    }

    public ValidUserResource getUserResource() {
        try {
            return ValidUserResource.of((UserResource)this.data);
        }
        catch (PreconditionFailedException e) {
            throw new IllegalStateException("Could not parse persisted user data into valid user resource", e);
        }
    }

    public void setUserResource(ValidUserResource resource) {
        this.data = resource.asUserResource();
    }

    public UUID getProfileId() {
        return this.profileId;
    }

    public @Nullable UUID getId() {
        return this.id;
    }

    public TenantId getTenantId() {
        return new TenantId(this.tenantId);
    }

    public void setTenantId(TenantId tenantId) {
        this.tenantId = (UUID)tenantId.getId();
    }
}

