/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence.model;

import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.externalid.ExternalSystemId;
import de.justsoftware.justimport.domain.model.externalid.InternalId;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class DbExternalIdMappingId
implements Serializable {
    private static final long serialVersionUID = -6312358767679355492L;
    private UUID tenantId;
    private String externalSystem;
    private String internalId;

    public DbExternalIdMappingId() {
    }

    public DbExternalIdMappingId(UUID tenantId, String externalSystem, String internalId) {
        this.tenantId = tenantId;
        this.externalSystem = externalSystem;
        this.internalId = internalId;
    }

    public DbExternalIdMappingId(TenantId tenantId, ExternalSystemId externalSystem, InternalId internalId) {
        this.tenantId = (UUID)tenantId.getId();
        this.externalSystem = (String)externalSystem.getId();
        this.internalId = internalId.asString();
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public String getSystemId() {
        return this.externalSystem;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbExternalIdMappingId mappingId = (DbExternalIdMappingId)o;
        return Objects.equals(this.tenantId, mappingId.tenantId) && Objects.equals(this.externalSystem, mappingId.externalSystem) && Objects.equals(this.internalId, mappingId.internalId);
    }

    public int hashCode() {
        return Objects.hash(this.tenantId, this.externalSystem, this.internalId);
    }
}

