/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence.model;

import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.externalid.ExternalId;
import de.justsoftware.justimport.domain.model.externalid.ExternalIdMapping;
import de.justsoftware.justimport.domain.model.externalid.ExternalSystemId;
import de.justsoftware.justimport.domain.model.externalid.InternalId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupId;
import de.justsoftware.justimport.persistence.model.DbExternalIdMappingId;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import java.util.Objects;
import java.util.UUID;

@Entity
@Table(name="ExternalIdMapping")
@IdClass(value=DbExternalIdMappingId.class)
public class DbExternalIdMapping {
    @Id
    private UUID tenantId;
    @Id
    private String externalSystem;
    private String externalId;
    @Id
    private String internalId;

    public DbExternalIdMapping() {
    }

    public DbExternalIdMapping(UUID tenantId, String externalSystem, String externalId, String internalId) {
        this.tenantId = tenantId;
        this.externalSystem = externalSystem;
        this.externalId = externalId;
        this.internalId = internalId;
    }

    public ExternalIdMapping toDto() {
        ProfileId internalId = ProfileId.isProfileId((String)this.internalId) ? ProfileId.parse((String)this.internalId) : UserGroupId.parse((String)this.internalId);
        return new ExternalIdMapping(new TenantId(this.tenantId), new ExternalSystemId(this.externalSystem), (InternalId)internalId, ExternalId.parse((String)this.externalId));
    }

    public static DbExternalIdMapping fromDto(ExternalIdMapping mapping) {
        return new DbExternalIdMapping((UUID)mapping.getTenantId().getId(), (String)mapping.getSystemId().getId(), mapping.getExternalId().asString(), mapping.getInternalId().asString());
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public String getExternalSystem() {
        return this.externalSystem;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public DbExternalIdMappingId getId() {
        return new DbExternalIdMappingId(this.tenantId, this.externalSystem, this.externalId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbExternalIdMapping that = (DbExternalIdMapping)o;
        return Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.externalSystem, that.externalSystem) && Objects.equals(this.externalId, that.externalId) && Objects.equals(this.internalId, that.internalId);
    }

    public int hashCode() {
        return Objects.hash(this.tenantId, this.externalSystem, this.externalId, this.internalId);
    }
}

