/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.kafka;

import de.justsoftware.justimport.business.profile.ScimFieldMappingService;
import de.justsoftware.justimport.kafka.model.KafkaFieldMapping;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

@Service
public class ScimFieldMappingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(ScimFieldMappingConsumer.class);
    private static final String PROFILE_FIELD_MAPPING_TOPIC = "just.import.fieldMapping";
    private final ScimFieldMappingService _scimFieldMappingService;

    @Autowired
    public ScimFieldMappingConsumer(ScimFieldMappingService scimFieldMappingService) {
        this._scimFieldMappingService = scimFieldMappingService;
    }

    @KafkaListener(topics={"just.import.fieldMapping"}, containerFactory="profileFieldMappingContainerFactory", id="fieldMappingConsumer", idIsGroup=false)
    public void listen(ConsumerRecords<String, KafkaFieldMapping> records) {
        records.forEach(record -> {
            KafkaFieldMapping fieldMapping = (KafkaFieldMapping)record.value();
            boolean isLatestVersion = this._scimFieldMappingService.saveNewFieldMapping(fieldMapping);
            if (isLatestVersion) {
                this._scimFieldMappingService.importProfileAttributes(fieldMapping);
            }
        });
    }
}

