/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.usergroup.ldap;

import com.google.common.base.MoreObjects;
import de.justsoftware.justimport.domain.model.common.ExternalIdField;
import de.justsoftware.justimport.domain.model.common.LDAPExternalIdUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import javax.naming.Name;
import org.jspecify.annotations.Nullable;
import org.springframework.ldap.odm.annotations.Attribute;
import org.springframework.ldap.odm.annotations.Entry;
import org.springframework.ldap.odm.annotations.Id;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Entry(objectClasses={"top"})
public final class LdapUserGroup {
    @Id
    private @Nullable Name _dn;
    @Attribute(name="cn", readonly=true)
    private @Nullable String _cn;
    @Attribute(name="description", readonly=true)
    private @Nullable String _description;
    @Attribute(name="objectGUID", type=Attribute.Type.BINARY, readonly=true)
    private byte @Nullable [] _objectGUID;
    @Attribute(name="guid", type=Attribute.Type.BINARY, readonly=true)
    private byte @Nullable [] _guid;
    @Attribute(name="entryUUID", readonly=true)
    private @Nullable String _entryUUID;
    private @Nullable String _name;

    public @Nullable String getCn() {
        return this._cn;
    }

    public @Nullable Name getDn() {
        return this._dn;
    }

    public @Nullable String getName() {
        return this._name;
    }

    public @Nullable String getDescription() {
        return this._description;
    }

    public byte @Nullable [] getObjectGUID() {
        return this._objectGUID != null ? (byte[])this._objectGUID.clone() : null;
    }

    public byte @Nullable [] getGuid() {
        return this._guid != null ? (byte[])this._guid.clone() : null;
    }

    public @Nullable String getEntryUUID() {
        return this._entryUUID;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dn", (Object)this._dn).add("entryUUID", (Object)this._entryUUID).add("objectGUID", (Object)this._objectGUID).add("guid", (Object)this._guid).add("name", (Object)this._name).add("description", (Object)this._description).add("cn", (Object)this._cn).toString();
    }

    public static Function<LdapUserGroup, Optional<String>> externalIdAccessor(ExternalIdField externalIdField) {
        Method externalIdMethod = Optional.ofNullable(ReflectionUtils.findMethod(LdapUserGroup.class, (String)("get" + StringUtils.capitalize((String)externalIdField.getFieldName())))).orElseThrow(() -> new IllegalArgumentException("External id attribute " + externalIdField.getFieldName() + " not suppported."));
        return group -> {
            try {
                return Optional.ofNullable(LDAPExternalIdUtil.getObjectIdAsString((Object)externalIdMethod.invoke(group, new Object[0]), (boolean)externalIdField.isGuid()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return Optional.empty();
            }
        };
    }
}

