/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.model.common;

import com.fasterxml.jackson.annotation.JsonValue;
import de.justsoftware.justimport.domain.model.common.ItemType;
import java.util.Arrays;

public abstract class AbstractId<T> {
    private final T _id;
    private final ItemType _type;
    private final int _hash;
    private final Object[] _hashObjects;

    AbstractId(T id, ItemType type) {
        this._id = id;
        this._type = type;
        this._hashObjects = new Object[]{id, type};
        this._hash = Arrays.hashCode(this._hashObjects);
    }

    public final T getId() {
        return (T)this._id;
    }

    public ItemType getType() {
        return this._type;
    }

    public final int hashCode() {
        return this._hash;
    }

    public final boolean equals(Object obj) {
        return this == obj || obj instanceof AbstractId && Arrays.equals(this._hashObjects, ((AbstractId)obj)._hashObjects);
    }

    private String idToString() {
        return this._id.toString();
    }

    @JsonValue
    public final String toString() {
        return String.valueOf(this._type) + "," + this.idToString();
    }

    public final String asString() {
        return this.toString();
    }

    public static Long longId(AbstractId<?> id) {
        return Long.parseLong(id.getId().toString());
    }
}

