/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.BaseLdapPathSource;
import org.springframework.ldap.support.LdapUtils;

public final class JustLdapUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JustLdapUtils.class);

    public static LdapName determineLdapBase(LdapTemplate ldapTemplate) {
        if (ldapTemplate.getContextSource() instanceof BaseLdapPathSource) {
            return ((BaseLdapPathSource)ldapTemplate.getContextSource()).getBaseLdapName();
        }
        return LdapUtils.emptyLdapName();
    }

    public static Name normalizeDn(Name dn, Name base) throws InvalidNameException {
        return dn.startsWith(base) ? dn : dn.addAll(0, base);
    }

    public static Name removeBase(Name dn, Name base) {
        try {
            String stringifiedDn = dn.toString();
            String baseWithPrefix = "," + String.valueOf(base);
            if (stringifiedDn.endsWith(baseWithPrefix)) {
                return new LdapName(stringifiedDn.replace(baseWithPrefix, ""));
            }
            return dn;
        }
        catch (InvalidNameException e) {
            LOG.error("Could not remove base {} from dn {}", (Object)base, (Object)dn);
            return dn;
        }
    }
}

