/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.messages.ListResponse;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.messages.SearchRequest;
import com.unboundid.scim2.common.messages.SortOrder;
import com.unboundid.scim2.common.types.GroupResource;
import com.unboundid.scim2.common.utils.SchemaUtils;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import de.justsoftware.justimport.auth.AuthorizationContext;
import de.justsoftware.justimport.business.usergroup.ScimGroupsService;
import de.justsoftware.justimport.controller.ScimRuntimeException;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupId;
import de.justsoftware.justimport.util.ResourcePreparer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nullable;
import java.beans.IntrospectionException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/scim/v2/Groups"})
public class ScimGroupsController {
    public static final String SCIM_GROUPS_PATH = "/api/scim/v2/Groups";
    public static final ResourceTypeDefinition GROUP_RESOURCE_TYPE_DEFINITION;
    private static final Logger LOG;
    private final ScimGroupsService _groupsService;

    @Autowired
    public ScimGroupsController(ScimGroupsService groupsService) {
        this._groupsService = groupsService;
    }

    @GetMapping
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Cast is always safe.")
    public ResponseEntity<ListResponse<GenericScimResource>> queryGroups(AuthorizationContext authCtx, @RequestParam(value="attributes", required=false) @Nullable Set<String> attributes, @RequestParam(value="excludedAttributes", required=false) @Nullable Set<String> excludedAttributes, @RequestParam(value="filter", required=false) @Nullable String filter, @RequestParam(value="sortBy", required=false) @Nullable String sortBy, @RequestParam(value="sortOrder", required=false) @Nullable SortOrder sortOrder, @RequestParam(value="startIndex", required=false) @Nullable Integer startIndex, @RequestParam(value="count", required=false) @Nullable Integer count) throws ScimException {
        SearchRequest request = new SearchRequest(attributes, excludedAttributes, filter, sortBy, sortOrder, startIndex, count);
        List searchResult = this._groupsService.find(request, authCtx);
        try {
            List<GenericScimResource> trimmedResources = searchResult.stream().map(group -> {
                try {
                    return this.trimGroup(attributes, excludedAttributes, resourcePreparer -> resourcePreparer.trimRetrievedResource((ScimResource)group));
                }
                catch (BadRequestException e) {
                    throw new ScimRuntimeException((Throwable)e);
                }
            }).toList();
            return ResponseEntity.ok((Object)new ListResponse(trimmedResources));
        }
        catch (ScimRuntimeException e) {
            throw (BadRequestException)e.getCause();
        }
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<GenericScimResource> getGroupById(AuthorizationContext authCtx, @PathVariable(value="id") String id, @RequestParam(value="attributes", required=false) @Nullable Set<String> attributes, @RequestParam(value="excludedAttributes", required=false) @Nullable Set<String> excludedAttributes) throws ResourceNotFoundException, BadRequestException {
        UserGroupId groupId = this.parseId(id);
        GroupResource group = this._groupsService.byId(groupId, authCtx);
        return ResponseEntity.ok((Object)this.trimGroup(attributes, excludedAttributes, resourcePreparer -> resourcePreparer.trimRetrievedResource((ScimResource)group)));
    }

    @PostMapping
    public ResponseEntity<GenericScimResource> createGroup(AuthorizationContext authCtx, @RequestBody GroupResource group, @RequestParam(value="attributes", required=false) @Nullable Set<String> attributes, @RequestParam(value="excludedAttributes", required=false) @Nullable Set<String> excludedAttributes) throws ScimException {
        GroupResource createdGroup = this._groupsService.create(group, authCtx);
        return new ResponseEntity((Object)this.trimGroup(attributes, excludedAttributes, resourcePreparer -> resourcePreparer.trimCreatedResource((ScimResource)createdGroup, (ScimResource)group)), (HttpStatusCode)HttpStatus.CREATED);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteGroupById(AuthorizationContext authCtx, @PathVariable(value="id") String id) throws ScimException {
        UserGroupId groupId = this.parseId(id);
        this._groupsService.delete(groupId, authCtx);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @PatchMapping(value={"/{id}"})
    public ResponseEntity<GenericScimResource> patchGroup(AuthorizationContext authCtx, @PathVariable(value="id") String id, @RequestBody PatchRequest request, @RequestParam(value="attributes", required=false) @Nullable Set<String> attributes, @RequestParam(value="excludedAttributes", required=false) @Nullable Set<String> excludedAttributes) throws ScimException {
        UserGroupId groupId = this.parseId(id);
        try {
            GroupResource group = this._groupsService.patch(groupId, request, authCtx);
            return ResponseEntity.ok((Object)this.trimGroup(attributes, excludedAttributes, resourcePreparer -> resourcePreparer.trimModifiedResource((ScimResource)group, (Iterable)request.getOperations())));
        }
        catch (JsonProcessingException jsonProcessingException) {
            String msg = String.format("UNKNOWN - could not parse group patch request for group id %s", id);
            LOG.error("{} - message: {}", (Object)msg, (Object)jsonProcessingException.getMessage());
            throw new ServerErrorException(msg);
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<GenericScimResource> replaceGroup(AuthorizationContext authCtx, @PathVariable(value="id") String id, @RequestBody GroupResource group, @RequestParam(value="attributes", required=false) @Nullable Set<String> attributes, @RequestParam(value="excludedAttributes", required=false) @Nullable Set<String> excludedAttributes) throws ResourceNotFoundException, BadRequestException {
        GroupResource updatedGroup = this._groupsService.replace(this.parseId(id), group, authCtx);
        return ResponseEntity.ok((Object)this.trimGroup(attributes, excludedAttributes, resourcePreparer -> resourcePreparer.trimReplacedResource((ScimResource)updatedGroup, (ScimResource)group)));
    }

    private UserGroupId parseId(String id) throws BadRequestException {
        try {
            UUID uid = UUID.fromString(id);
            return new UserGroupId(uid);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Supplied ID is not a UUID", "invalidValue");
        }
    }

    private GenericScimResource trimGroup(@Nullable Set<String> attributes, @Nullable Set<String> excludedAttributes, Function<ResourcePreparer<GroupResource>, GenericScimResource> trimFunc) throws BadRequestException {
        UriComponentsBuilder uriBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().path(SCIM_GROUPS_PATH);
        ResourcePreparer resourcePreparer = new ResourcePreparer(GROUP_RESOURCE_TYPE_DEFINITION, attributes, excludedAttributes, uriBuilder.build(new Object[0]));
        return trimFunc.apply((ResourcePreparer<GroupResource>)resourcePreparer);
    }

    static {
        LOG = LoggerFactory.getLogger(ScimGroupsController.class);
        try {
            GROUP_RESOURCE_TYPE_DEFINITION = new ResourceTypeDefinition.Builder("GroupResource", SCIM_GROUPS_PATH).setCoreSchema(SchemaUtils.getSchema(GroupResource.class)).build();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }
}

