/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.auth;

import de.justsoftware.justimport.auth.AuthorizationContext;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.exceptions.UnauthorizedException;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class AuthorizationContextResolver
implements HandlerMethodArgumentResolver {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationContextResolver.class);

    public boolean supportsParameter(MethodParameter parameter) {
        return AuthorizationContext.class.equals((Object)parameter.getParameterType());
    }

    public AuthorizationContext resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws UnauthorizedException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new UnauthorizedException();
        }
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken token = (JwtAuthenticationToken)authentication;
            TenantId tenantId = this.retrieveTenantId(token);
            return new AuthorizationContext(tenantId);
        }
        LOG.warn("Authentication of type {} is not supported", (Object)authentication.getClass().getName());
        throw new UnauthorizedException();
    }

    private TenantId retrieveTenantId(JwtAuthenticationToken token) {
        Object hopefullyATenantId = token.getCustomJwtClaims().get((Object)"tenantId");
        if (hopefullyATenantId == null) {
            throw new UnauthorizedException();
        }
        try {
            return TenantId.parse((String)hopefullyATenantId.toString());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Receive an unparsable TenantId {}", hopefullyATenantId);
            throw new UnauthorizedException("An error occurred authorizing the action.");
        }
    }
}

