/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security.filter;

import de.justsoftware.gateway.security.AuthenticationToJwtStringConverter;
import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import de.justsoftware.jwtfilter.verifier.JwtVerificationConstraintBuilder;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import java.time.Duration;
import java.time.Instant;
import java.util.regex.Pattern;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.HttpCookie;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;

@Component
public class JustSocialAppCookieGatewayFilterFactory
extends AbstractGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(JustSocialAppCookieGatewayFilterFactory.class);
    private static final Pattern JUST_SOCIAL_APP_USER_AGENT_PATTERN = Pattern.compile(".*JustSocial/.*");
    private final AuthenticationToJwtStringConverter _converter;
    private final JwtVerifier _jwtVerifier;

    public JustSocialAppCookieGatewayFilterFactory(AuthenticationToJwtStringConverter converter, JwtVerifier jwtVerifier) {
        super(AbstractGatewayFilterFactory.NameConfig.class);
        this._converter = converter;
        this._jwtVerifier = jwtVerifier;
    }

    public GatewayFilter apply(AbstractGatewayFilterFactory.NameConfig config) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private boolean hasNoOrOldCookie(ServerWebExchange exchange) {
        HttpCookie existingCookie = (HttpCookie)exchange.getRequest().getCookies().getFirst((Object)"just-id");
        if (existingCookie == null) {
            return true;
        }
        JwtVerificationConstraintBuilder constraintBuilder = new JwtVerificationConstraintBuilder().withRequireSubject();
        try {
            JwtClaims claims = this._jwtVerifier.verify(constraintBuilder, existingCookie.getValue());
            Instant minimumExpirationTime = Instant.now().plus(Duration.ofHours(1L));
            return claims.getExpirationTime().getValueInMillis() < minimumExpirationTime.toEpochMilli();
        }
        catch (JwtKeyLoadingException | MalformedClaimException | InvalidJwtException e) {
            LOG.debug("got invalid just-id cookie from authenticated Just Social App", e);
            return true;
        }
    }

    public static boolean isJustSocialApp(ServerWebExchange exchange) {
        return exchange.getRequest().getHeaders().getOrEmpty((Object)"User-Agent").stream().anyMatch(userAgent -> JUST_SOCIAL_APP_USER_AGENT_PATTERN.matcher((CharSequence)userAgent).matches());
    }
}

