/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.justsoftware.gateway.ids.ExternalId;
import de.justsoftware.gateway.ids.ProfileId;
import de.justsoftware.gateway.ids.TenantId;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InMemoryExternalIdMapper {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryExternalIdMapper.class);
    private final Table<TenantId, ExternalId, ProfileId> _idTable = HashBasedTable.create();

    public void setMapping(TenantId tenantId, ExternalId externalId, ProfileId internalId) {
        LOG.debug(String.format("Adding mapping. TenantId: %s | ExternalId: %s | InternalId: %s", tenantId, externalId, internalId));
        this._idTable.put((Object)tenantId, (Object)externalId, (Object)internalId);
    }

    public void removeMapping(ProfileId internalId) {
        Set cells = this.findByInternalId(internalId);
        cells.forEach(cell -> {
            LOG.debug(String.format("Removing mappings for user %s", internalId));
            TenantId rowKey = (TenantId)cell.getRowKey();
            ExternalId columnKey = (ExternalId)cell.getColumnKey();
            this._idTable.remove((Object)rowKey, (Object)columnKey);
        });
    }

    private Set<Table.Cell<TenantId, ExternalId, ProfileId>> findByInternalId(ProfileId internalId) {
        return this._idTable.cellSet().stream().filter(cell -> {
            ProfileId value = (ProfileId)cell.getValue();
            return value != null && value.equals((Object)internalId);
        }).collect(Collectors.toSet());
    }

    public void clearAllMappings() {
        this._idTable.clear();
    }

    public @Nullable ProfileId lookupInternalId(TenantId tenantId, ExternalId externalId) {
        return (ProfileId)this._idTable.get((Object)tenantId, (Object)externalId);
    }
}

